<?php
require_once(dirname(__FILE__).'/../../core/Application.php');
/**
 * LB_Auth アプリケーションコンテナクラス
 *
 * LICENSE: This source file is subject to GNU GENERAL PUBLIC LICENSE Version 3
 * http://www.gnu.org/licenses/gpl-3.0.txt.
 *
 * @package     LabbitBox
 * @subpackage  LB_Auth
 * @copyright   2010 LabbitBox Development Team.
 * @license     GPL v3 http://www.gnu.org/licenses/gpl-3.0.txt
 * @author      minotaur <minotaur@labbitbox.org>
 * @since       2011/08/22
 * @link        http://labbitbox.org/
 * @see         http://labbitbox.org/
 */
class LB_Auth_App extends Application{
    protected $_lbSession  = NULL;
    protected $_controller = NULL;
    protected $_request          ;
    protected $_session          ;
    protected $_shared           ;
    protected $_params           ; //起動パラメータ
 
    function __construct($confDir, $appDir, $docRoot = ''){
        //イニシャライズオブジェクト生成
        require_once(dirname(__FILE__).'/../../core/Init.php');
        $wInit  = new Init( $confDir,                        //設定ファイルディレクトリ
                            dirname(__FILE__).'/../../core', //フレームワークディレクトリ
                            $appDir,                         //プリケーションディレクトリ
                            $docRoot);                       //ドキュメントルート

        //基本変数オブジェクト生成
        $this->_request = new Request() ;
        $this->_session = new Session() ;
        $this->_shared  = new Shared()  ;

        //設定ファイルロード
        $wInit->loadConfig($this); //アプリケーションオブジェクト

        //コントローラ前処理オブジェクト
        //CLIチェック
        $wPrefix    = (isset($_SERVER['argc']) ? 'cli' : 'sys');
        if ($wPrefix == 'cli'){
            argvToRequest();
        }else if(file_exists(dirname(__FILE__).'/LB_Auth_Precontroller.php')){
            require_once(dirname(__FILE__).'/LB_Auth_Precontroller.php');
            $wPrecontroller   = new LB_Auth_Precontroller($this);
            $this->_lbSession = $wPrecontroller->lbSession();
        }

        //コントローラオブジェクト生成
        $type       = ($this->request()->isExist('type') ? $this->request('type') : $this->shared('SYSTEM_CONFIG')->value($wPrefix.'.type'));
        switch ($type){
            case 'ajax':
            case 'http':
                require_once(dirname(__FILE__).'/LB_Auth_AjaxRequest.php');
                $this->_controller  = new LB_Auth_AjaxRequest($this);
                break;
            
            case 'ds':
                require_once(BASE_LIB.'/DataCollector.php');
                $this->_controller  = new DataCollector($this);
                break;
            
            case 'rpc':
                require_once(BASE_LIB.'/Router.php');
                $this->_controller  = new Router($this);
                break;
            
            case 'cli':
                require_once(BASE_LIB.'/CLI.php');
                $this->_controller  = new Cli($this);
                break;
            
            case 'html':
            default:
                require_once(dirname(__FILE__).'/LB_Auth_Renderer.php');
                if (isset($wPrecontroller) && $this->_lbSession->getTemplate){
                $wTemplateName  = $this->_lbSession->getTemplate();
                }
                else{
                $wTemplateName  = $this->shared('SYSTEM_CONFIG')->value('sys.base_template');
                }
         
                $wTemplatePath  = (TEMPLATE_DIR == '' ? PRJHOME : TEMPLATE_DIR);
                $this->_controller  = new LB_Auth_Renderer($this, $wTemplateName, $wTemplatePath);
                break;
        }
    }



    /**
     * Prepare Account Interface
     *
     * @param HtmlBasicView $view View Object
     * @param Application   $app  Application Object
     */
    function prepare($view, $app){

        // ログインインターフェース
        if($view->getElementById('lgif')){

            if(file_exists(TEMPLATE_DIR.'/LB_Auth_LGIF_before.tpl.html')){
                $templateDir  = TEMPLATE_DIR;
            }else{
                $templateDir  = dirname(__FILE__);
            }
            if(file_exists(BASE_APP.'/LB_Auth_LGIF_Customized_E.php')){
                $appDir  = BASE_APP;
                require_once($appDir.'/LB_Auth_LGIF_Customized_E.php');
                $lgif = new LB_Auth_LGIF_Customized_E($view, $app, 'LB_Auth_LGIF_before.tpl.html', 'REGION', $templateDir);
            }else{
                $appDir  = dirname(__FILE__);
                require_once($appDir.'/LB_Auth_LGIF_E.php');
                $lgif = new LB_Auth_LGIF_E($view, $app, 'LB_Auth_LGIF_before.tpl.html', 'REGION', $templateDir);
            }

            $lgif->main();
            $view->replaceRegion($lgif, 'lgif');
        }

        // アカウント登録インターフェース
        if($view->getElementById('accreg')){
            if(file_exists(BASE_APP.'/LB_Auth_AccReg_E.php')){
                $appDir  = BASE_APP;
                require_once($appDir.'/LB_Auth_AccReg_Customized_E.php');
                $em = new LB_Auth_AccReg_Customized_E($view, $app, 'LB_Auth_AccReg.tpl.html', 'REGION', TEMPLATE_DIR);
            }else{
                $appDir  = dirname(__FILE__);
                require_once($appDir.'/LB_Auth_AccReg_E.php');
                $em = new LB_Auth_AccReg_E($view, $app, 'LB_Auth_AccReg.tpl.html', 'REGION', TEMPLATE_DIR);
            }
            $method = $app->request()->valueDef('method', 'main');
            $em->$method();
            $view->replaceRegion($em, 'accreg');
        }
    }



    /**
     * ランダムな半角英数字を生成する(記号を除く)
     * 生成文字は 0-9, A-Z, a-z ただし 0, 1, I, O, l は除く
     * @param  int $agLength 生成文字列の長さ
     * @return string
     */
    public static function getRandomKey($length){
        // 文字定義
        $tbl = array('2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'L', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z');
        $tblSize = (count($tbl) - 1) * 1;
        $length = $length * 1;
        $code = '';
        for ($i = 0; $i < $length; $i++){
            $code .= $tbl[rand(0, $tblSize)];
        }
        return $code;
    }



}
?>
