<?php
require_once(BASE_LIB.'/EmbededView.php');
/**
 * Login Interface as HtmlParts
 *
 * @package     LabbitBox
 * @subpackage  LB_Auth
 * @author      minotaur <minotaur@labbitbox.org>
 * @since       2011/08/23
 */
class LB_Auth_LGIF_E extends EmbededView {

    protected $_acc;

    public function main(){
        require_once(BASE_LIB.'/ModifyElement.php');
        $this->_acc = $_SESSION[$this->config('app.LB_Auth.sysId').'_acc'];
        if($_SESSION[$this->config('app.LB_Auth.sysId').'_auth']){
            $this->afterLogin();
        }else{
            $this->beforeLogin();
        }
   }



   public function beforeLogin(){
        if(file_exists(TEMPLATE_DIR.'/LB_Auth_LGIF_before.tpl.html')){
            $templateDir  = TEMPLATE_DIR;
        }else{
            $templateDir  = dirname(__FILE__);
        }
        $templateFile = '/LB_Auth_LGIF_before.tpl.html';
        $this->setTemplate($templateFile, $templateDir);

        // Javascript定義
        $this->addJsInclude(JS_LIB_DIR.'/prototype.js');
        $this->addJsInclude(JS_LIB_DIR.'/labbitbox.js');
        $this->addJsInclude(JS_DIR.'/LB_Auth_LGIF.js');
        
        // ログインボタンへの機能割り付け
        $wkBtn = new ModifyElement($this, 'lgif_login_btn');
        $wkEvent  = $wkBtn->onAjaxClick(array('lgif_email', 'lgif_password', 'lgif_keepalive_check'));
        $wkEvent->execParam('action', 'LB_Auth_LGIF');

        //passwordで改行を押した時にログインさせる機能割り付け
        $wkTxt = new ModifyElement($this, 'lgif_password');
        $wkAjaxEvent = array('beforeParamSet' => 'chkKeyType');
        $wkEvent  = $wkTxt->onAjaxKeyPress(array('lgif_email', 'lgif_password', 'lgif_keepalive_check'), array(),$wkAjaxEvent);
        $wkEvent->execParam('action', 'LB_Auth_LGIF');
        $wkEvent->execParam('method', 'lgif_login_btn_click');

        if($_SERVER['HTTPS']){
            $sslLogin = new ModifyElement($this, 'lgif_ssl_login');
            $sslLogin->style('display', 'none');
        }else{
            if(strpos($_SERVER['HTTP_HOST'], 'dev')!==FALSE){
                //SSL(開発版は偽リンク)
                $sslLogin = new ModifyElement($this, 'lgif_ssl_login');
                $sslLogin->attribute('href', '/');
            }else{
                //SSL
                $sslLogin = new ModifyElement($this, 'lgif_ssl_login');
                $sslLogin->attribute('href', 'https://'.$_SERVER['HTTP_HOST'].'/');
            }
        }
    }




    public function afterLogin(){
        if(file_exists(TEMPLATE_DIR.'/LB_Auth_LGIF_after.tpl.html')){
            $templateDir  = TEMPLATE_DIR;
        }else{
            $templateDir  = dirname(__FILE__);
        }
        $templateFile = 'LB_Auth_LGIF_after.tpl.html';
        $this->setTemplate($templateFile, $templateDir);

        // Javascript定義
        $this->addJsInclude(JS_LIB_DIR.'/prototype.js');
        $this->addJsInclude(JS_LIB_DIR.'/labbitbox.js');
        $this->addJsInclude(JS_DIR.'/LB_Auth_LGIF.js');
        
        // --------------------------------------------------------------------
        // ログイン名
        $acclink = new ModifyElement($this, 'lgif_acclink');
        $acclink->text( $this->_acc['SCREEN_NAME'] );
        $acclink->attribute('title', $this->_acc['SCREEN_NAME']." 様のマイページ" );
        $acclink->attribute('href', '/prof.php?u='.$this->_acc['PK']);

        // 最終ログイン日時
        $lastlogin_dt = new ModifyElement($this, 'lgif_lastlogin_dt');
        if ($this->_acc['LAST_LOGIN_DT']){
            $lastlogin_dt->text( strftime('%Y年%m月%d日 %H時%M分%S秒', strtotime($this->_acc['LAST_LOGIN_DT'])) );
        }else{
            $lastlogin_dt->text('   年  月  日   時  分  秒');
        }

        // 自分ではないユーザ
        $notme_user = new ModifyElement($this, 'lgif_notme_user');
        $notme_user->text( $this->_acc['SCREEN_NAME'] );

        // ログアウトボタンへの機能割り付け
        $wkBtn = new ModifyElement($this, 'lgif_logout_btn');
        $wkEvent  = $wkBtn->onAjaxClick(array('lgif_logout'), array('action' => 'LB_Auth_LGIF', 'method' => 'lgif_logout_btn_click'));
        
        //「こちら」クリックによるログアウト機能の割り付け
        $wkLogOutSpan = new ModifyElement($this, 'lgif_logout_span');
        $wkEvent  = $wkLogOutSpan->onAjaxClick(array('lgif_logout'), array('action' => 'LB_Auth_LGIF', 'method' => 'lgif_logout_btn_click'));
        $wkLogOutLink = new ModifyElement($this, 'lgif_logout_link');
        $wkLogOutLink->attribute('onclick', 'return false');//リンクを無効にする(画面の見た目のためにリンクにしてあるが、リンクとしては機能させない)
    }

}

?>
