<?php
    //========================================================================================================================
    /**
     * LB_Auth MVCクラス：コントローラー（HTML画面表示用）
     *
     * LICENSE: This source file is subject to GNU GENERAL PUBLIC LICENSE Version 3
     * http://www.gnu.org/licenses/gpl-3.0.txt.
     *
     * @package    LabbitBox
     * @subpackage LB_Auth
     * @copyright  2010 LabbitBox Development Team.
     * @license    GPL v3 http://www.gnu.org/licenses/gpl-3.0.txt
     * @author     neobaba <neobaba@labbitbox.org>
     * @author     minotaur <minotaur@labbitbox.org>
     * @version    v0.1
     * @since      2010/2/26
     * @link       http://labbitbox.org/
     * @see        http://labbitbox.org/
     */
    //========================================================================================================================
    require_once(dirname(__FILE__).'/LB_Auth_Controller.php');

    class LB_Auth_Renderer extends LB_Auth_Controller {
        private $_templateName  = '';
        private $_templatePath  = '';

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * コンストラクタ/デストラクタ
         * @param object    $application    アプリケーションオブジェクト
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function __construct($application, $templateName, $templatePath){
            parent::__construct($application);
            $this->_templateName    = $templateName;
            $this->_templatePath    = $templatePath;

            // ビューオブジェクト生成
            $wkViewClassName               = $this->_app->param('action').'_V';
            $wkViewFilePath                = PRJHOME.'/'.$wkViewClassName.'.php';

            $wkLB_Auth_ViewClassName       = $this->_app->param('action').'_V';
            $wkLB_Auth_ViewFilePath        = dirname(__FILE__).'/'.$wkViewClassName.'.php';

            $wkLB_Auth_CustomViewClassName = $this->_app->param('action').'_Customized_V';
            $wkLB_Auth_CustomViewFilePath  = PRJHOME.'/'.$wkViewClassName.'.php';

            if(strpos($this->_app->param('action'), 'LB_Auth')===FALSE){
                if(file_exists($wkViewFilePath)){
                    require_once($wkViewFilePath);
                    $this->_view   = new $wkViewClassName($this->_app);
                }
            }else{
                if(file_exists($wkLB_Auth_CustomViewFilePath) ){
                    require_once($wkLB_Auth_CustomViewFilePath);
                    $this->_view   = new $wkLB_Auth_CustomViewClassName($this->_app);
                }else{
                    if(file_exists($wkLB_Auth_ViewFilePath)){
                        require_once($wkLB_Auth_ViewFilePath);
                        $this->_view   = new $wkLB_Auth_ViewClassName($this->_app);
                    }
                }
            }
        }
    
        //-------------------------------------------------------------------------------------------------------------------
        /**
         * MVC実行
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function execute(){
            //モデル
            if ($this->_model != NULL){
                $wkFunction     = $this->_app->param('method');
                $this->_model->$wkFunction($this->_app);
            }
            
            //ビュー
            if ($this->_view != NULL){
                if ($this->_templateName !== ''){
                    $this->_view->setTemplate($this->_templateName, $this->_templatePath);
                }
                $wkFunction     = $this->_app->param('method');
                $this->_view->$wkFunction($this->_app);
                $this->_app->prepare($this->_view, $this->_app);
                print $this->_view->response(FALSE);
            }
        }
    
    }

?>
