<?php
    //========================================================================================================================
	/**
     * MVCビュークラス ExtJS用ビュー
	 *
     * html/head/body を含む基本テンプレートにアプリケーションのメインテンプレートを載せたビュー
     * ヘッダとフッタは基本テンプレートに記述
	 *
	 * LICENSE: This source file is subject to GNU GENERAL PUBLIC LICENSE Version 3
	 * http://www.gnu.org/licenses/gpl-3.0.txt.
	 *
	 * @package    LabbitBox
	 * @subpackage modExtJs
	 * @copyright  2010 LabbitBox Development Team.
	 * @license    GPL v3 http://www.gnu.org/licenses/gpl-3.0.txt
     * @author     neobaba <neobaba@labbitbox.org>
	 * @version    v0.1 alpha3
	 * @since      -
	 * @link       http://labbitbox.org/
	 * @see        http://labbitbox.org/
	 */
    //========================================================================================================================
    require_once(FWLIB.'/view.php');
    require_once(EXTJS.'/ExtDirect/API.php');
//    require_once(EXTJS.'/ExtDirect/Router.php');
    require_once(EXTJS.'/ExtDirect/CacheProvider.php');

    class ExtjsView extends View{
        private $_extDsList         = array();
        private $_extUiList         = array();

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * コンストラクタ/デストラクタ
         *
         * @param object    $agApplication      アプリケーションオブジェクト
         * @param string    $agTemplateName     テンプレート名
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function __construct($agApplication, $agTemplateName = ''){
            //スーパークラスコンストラクタ
            parent::__construct($agApplication, $agTemplateName);
        }

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * HTMLページ初期生成処理（コンストラクタよりコールされる)
         *
         * @param object    $agApplication  アプリケーションオブジェクト
         * @param string    $agMode         動作モード NULL:html表示/'a':Ajax表示/'d':Ajax値取得
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function editHtml(){
            //---------------------------------------------------------------------------------------------
            //  CSS(<style>タグ)：class属性/エレメントID指定などによるスタイルの指定
            //---------------------------------------------------------------------------------------------
            //<head>タグに外部CSSファイルのリンク定義を追加
            $this->addCssLink('ext-all', 'resources/css');          //ExtJS用CSS
            $this->addCssLink('xtheme-gray', 'resources/css');      //ExtJS用テーマCSS(グレイ基調)
            $this->addCssLink('LockingGridView', 'js/lib/ux/css');  //ExtJS:ux:LockingGridView用CSS

            //---------------------------------------------------------------------------------------------
            //  ExtJS用定義
            //  ※定義順序重要
            //---------------------------------------------------------------------------------------------
            $this->addJsInclude('js/lib/ext-base.js');
            $this->addJsInclude('js/lib/ext-all.js');
            $this->addJsInclude('js/lib/ext-lang-ja.js');
            //ux
            $this->addJsInclude('js/lib/ux/ux-all.js');
            //images
            $this->addJsScript(sprintf("Ext.BLANK_IMAGE_URL = '%s';", $this->conf('BLANK_IMAGE_URL')));
            
            //---------------------------------------------------------------------------------------------
            //  FW用Javascript定義
            //  ※定義順序重要
            //---------------------------------------------------------------------------------------------
            $this->addJsInclude('js/fw/ext.js');
//            $this->addJsInclude('js/fw/ajax.js');

        }

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * レスポンス文字列生成
         * 自DOMオブジェクトからHTML文字列に展開する
         *
         * @return string   HTML文字列
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function build(){
        
            switch($this->_app->type()){
                //-----------------------------------------------------------------------------------------------------------
                //  html表示
                //-----------------------------------------------------------------------------------------------------------
                default:
                    $this->insertExtDsUrl();    //ExtJS用定義
                    $this->insertExtUi();       //ExtJS用定義
                    parent::build();
                    break;
                    
            }
        }
        
        //-------------------------------------------------------------------------------------------------------------------
        /**
         * Javascript変数定義
         * 設定ファイル(system.xml)から変数定義文字列に展開する
         */
        //-------------------------------------------------------------------------------------------------------------------
        private function insertExtDsUrl(){
            $wkLoadJs   = $this->_doc->createElement('script');
            $wkLoadJs->setAttribute('language', 'JavaScript');
            $wkDefinition   = array();
            $wkDefinition[] = "\n<!--\n";
            
            //データストア用データ取得URL
            $wkDsUrl    = $this->_app->ss('SYSTEM_CONF')->get()->getElementsByTagName('dsUrl');
            foreach($wkDsUrl as $_dsUrl){
                $wkAttrList = array('type=ds');
                foreach($_dsUrl->attributes as $_attr => $_node){
                    if ($_attr != 'id'){
                        $wkAttrList[]   = $_attr.'='.$_node->value.'';
                    }
                }
                $wkId   = $_dsUrl->getAttribute('id');
                $wkDefinition[] = "var ".$wkId." = '".$_dsUrl->nodeValue."?".implode("&", $wkAttrList)."';";
            }
            
            //Javascript用変数定義
            $wkJsVariables  = $this->_app->ss('SYSTEM_CONF')->get()->getElementsByTagName('jsVariable');
            foreach($wkJsVariables as $_jsVariable){
                $wkDefinition[] = $this->editValiableDefinition($_jsVariable);
            }

            //テキストノード生成
            $wkDefinition[] = "\n-->\n";
            $wkTextNode = $this->_doc->createTextNode(implode($this->conf('delimiterForJs'), $wkDefinition));
            $wkLoadJs->appendChild($wkTextNode);
            
            //定義ノードをheadタグに追加
            $wkHeadNode = $this->_doc->getElementsByTagName('head')->item(0);
            $wkHeadNode->appendChild($wkLoadJs);
        }
        
        //-------------------------------------------------------------------------------------------------------------------
        /**
         * Javascript変数定義文編集
         * @param object    $agNode     システム設定ファイル上の対象ノードオブジェクト
         */
        //-------------------------------------------------------------------------------------------------------------------
        private function editValiableDefinition($agNode){
            $wkId   = $agNode->getAttribute('id');
            $wkType = ($agNode->hasAttribute('type') ? $agNode->getAttribute('type') : 'string');
            switch ($wkType){
                case 'string':
                    $wkValue    = quote($agNode->nodeValue);
                    break;
                    
                default:
                    $wkValue    = $agNode->nodeValue;
            }
            return "var ".$wkId." = ".$wkValue.";";
        }

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * ExtJS UI定義ファイルファイルインクルード定義追加
         *
         * @param string    $agElement      コンテナエレメント名(テンプレート上の当エレメント(div等)に挿入される)
         * @param string    $agUiClassName  UIクラス名：クラス名とファイル名は同一であることが必須
         * @param boolean   $agAutoDraw     起動時描画フラグ
         * @param string    $agPath         ドキュメントルート直下からのディレクトリ構造
         *                                  デフォルト：ドキュメントルート直下のuiディレクトリに存在することが前提
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function addExtUi($agUiClassName, $agElement = '', $agAutoDraw = TRUE, $agPath = 'ui'){
            $this->addJsInclude($agPath.'/'.$agUiClassName.'.ui.js');
            $this->addJsInclude($agPath.'/'.$agUiClassName.'.js');
            
            $this->_extUiList[$agUiClassName]   = array('TARGET_ELEMENT' => $agElement, 'INIT_DRAW' => $agAutoDraw);
        }

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * ExtJS データストア定義ファイルインクルード定義追加
         *
         * @param string    $agDsClassName  データストアクラス名：クラス名とファイル名は同一であることが必須
         * @param string    $agStoreID      ストアID:$agDsPathで指定されたJavascriptファイルに記述されたstoreId
         *                                  ''の場合は起動時にload()メソッドを実行しない
         * @param string    $agPath         ドキュメントルート直下からのディレクトリ構造
         *                                  デフォルト：ドキュメントルート直下のuiディレクトリに存在することが前提
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function addExtDs($agDsClassName, $agStoreID = '', $agPath = 'ui'){
            $this->addJsInclude($agPath.'/'.$agDsClassName.'.js');
            
            if ($agStoreID !== ''){
                $this->_extDsList[]     = $agStoreID;
            }
        }

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * ExtJS 起動時イベントハンドラ→DOM追加
         * addExtUi()およびaddExtDs()で追加したExtJS用クラス定義をExt.onReady()関数内で生成する処理を追加する
         */
        //-------------------------------------------------------------------------------------------------------------------
        private function insertExtUi(){
            $wkOnReady          = array();
            $wkOnReady[]        = "Ext.onReady(function() {";

            //データストア定義
            foreach ($this->_extDsList as $_storeId){
                $wkOnReady[]    = "Ext.StoreMgr.get('".$_storeId."').load();";
            }
            
            //ユーザーインターフェース定義
            foreach ($this->_extUiList as $_uiClassName => $_params){
                $wkElementID    = $_params['TARGET_ELEMENT'];
                if ($wkElementID !== ''){
                    $wkRegionList[] = $_uiClassName;
                    //$wkOnReady[]    = "rg['".$_uiClassName."'] = new ".$_uiClassName."();";
//--
/*
                    $wkOnReady[]    = "addRegion('".$_uiClassName."');";
                    if ($_params['INIT_DRAW']){
                            $wkOnReady[]    = "renderRegion('".$_uiClassName."', '".$wkElementID."');";
                    }
*/
//--
                    if ($_params['INIT_DRAW']){
                        $wkOnReady[]    = "addRegion('".$_uiClassName."', '".$wkElementID."');";
                    }
                    else{
                        $wkOnReady[]    = "addRegion('".$_uiClassName."');";
                    }

                    //$wkRegionList[] = "var wk".$_uiClassName.";";
                    //$wkOnReady[]    = "wk".$_uiClassName." = new ".$_uiClassName."({renderTo: Ext.get('".$wkElementID."')});";
                    //$wkOnReady[]    = "wk".$_uiClassName.".show();";

                    //$wkOnReady[]    = "var wk".$_uiClassName." = new ".$_uiClassName."({renderTo: Ext.get('".$wkElementID."')});";
                    //$wkOnReady[]    = "wk".$_uiClassName.".show();";
                }
            }
            $wkOnReady[]        = "});";
            
            $this->addJsScript(implode($this->conf('delimiterForJs'), $wkOnReady));
        }

    }

?>
