<?php
    //========================================================================================================================
    /**
     * Webアプリケーション：ビューサンプル実装
     *
     * LICENSE: This source file is subject to GNU GENERAL PUBLIC LICENSE Version 3
     * http://www.gnu.org/licenses/gpl-3.0.txt.
     *
     * @package    SampleApps
     * @subpackage A1000
     * @copyright  2010 LabbitBox Development Team.
     * @license    GPL v3 http://www.gnu.org/licenses/gpl-3.0.txt
     * @author     neobaba <neobaba@labbitbox.org>
     * @version    v0.1
     * @since      -
     * @link       http://labbitbox.org/
     * @see        http://labbitbox.org/
     */
    //========================================================================================================================
    require_once(BASE_LIB.'/HtmlView.php');
    require_once(BASE_LIB.'/HtmlTableGrid.php');

    class A1000_V extends HtmlView {
        //-------------------------------------------------------------------------------------------------------------------
        /**
         * コンストラクタ/デストラクタ
         *
         * @param object    $application  アプリケーションオブジェクト
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function __construct($application){
           parent::__construct($application);
        }

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * HTMLページ初期生成処理
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function editHtml(){
            //---------------------------------------------------------------------------------------------
            //  Javascriptライブラリ定義
            //---------------------------------------------------------------------------------------------
            $this->addJsInclude(JS_LIB_DIR.'/prototype.js');
            $this->addJsInclude(JS_LIB_DIR.'/labbitbox.js');
            //$this->addJsInclude(JS_LIB_DIR.'/htmlGrid.js');
            
            //---------------------------------------------------------------------------------------------
            //  プログラム個別Javascript定義
            //---------------------------------------------------------------------------------------------
            $this->addJsInclude(JS_DIR.'/A1000.js');
            
            //---------------------------------------------------------------------------------------------
            //  エレメント編集
            //---------------------------------------------------------------------------------------------
            $this->editStyles();
            $this->editElements();
        }
        
        //-------------------------------------------------------------------------------------------------------------------
        /**
         * スタイル定義編集
         */
        //-------------------------------------------------------------------------------------------------------------------
        private function editStyles(){
            $this->addCssLink('exTop', 'css');

            //<head>タグにスタイル定義の記述を追加
            $this->addStyleCss('.test_class1', array('width' => '100px', 'height' => '100px', 'background-color' => 'green'));
        }
        
        //-------------------------------------------------------------------------------------------------------------------
        /**
         * エレメント編集
         */
        //-------------------------------------------------------------------------------------------------------------------
        private function editElements(){
            require_once(BASE_LIB.'/ModifyElement.php');

            //汎用イベント
            
            $testButton1 = new ModifyElement($this, 'MENU1');
            $testButton1->onClick();
            /*            
            $testButton1 = new ModifyElement($this, 'MENU2');
            $testButton1->onClick();
            return;
             */

            //------------------------------------------------------------
            //Ajaxイベント
            $testButton2 = new ModifyElement($this, 'MENU2');
            $wEvent1 = $testButton2->onAjaxClick();//_debugRes();
            $wEvent1->execParam('action', 'A1010');
            $wEvent1->execParam('method', 'drawA1010');
            //$wEvent1->execParam('type', 'ajax');

            $testButton3 = new ModifyElement($this, 'MENU3');
            $wEvent2 = $testButton3->onAjaxClick();//_debugRes();
            $wEvent2->execParam('action', 'A1020');
            $wEvent2->execParam('method', 'main');

            //------------------------------------------------------------
            //ログアウト
            $wLogout = new ModifyElement($this, 'LOGOUT');
            $wEvent3 = $wLogout->onAjaxClick();
            $wEvent3->handler('beforeRequest', 'confirmLogout');
            $wEvent3->execParam('action', 'A1000');

            //------------------------------------------------------------
            //音声再生
            $wSound = new ModifyElement($this, 'SOUND');
            $wEvent4 = $wSound->onAjaxClick();//_debugRes();
            $wEvent4->execParam('action', 'A1030');
            $wEvent4->execParam('method', 'main');

            //------------------------------------------------------------
            //ダイヤグラム表示
            $wDiagram = new ModifyElement($this, 'DIAGRAM');
            $wEvent5 = $wDiagram->onAjaxClick();//_debugRes();
            $wEvent5->execParam('action', 'F1010');
            $wEvent5->execParam('method', 'main');
        }
    }

?>
