<?php
    //========================================================================================================================
    /**
     * Webアプリケーション：Ajax用ビューサンプル実装
     *
     * LICENSE: This source file is subject to GNU GENERAL PUBLIC LICENSE Version 3
     * http://www.gnu.org/licenses/gpl-3.0.txt.
     *
     * @package    SampleApps
     * @subpackage A1010
     * @copyright  2010 LabbitBox Development Team.
     * @license    GPL v3 http://www.gnu.org/licenses/gpl-3.0.txt
     * @author     neobaba <neobaba@labbitbox.org>
     * @version    v0.1
     * @since      -
     * @link       http://labbitbox.org/
     * @see        http://labbitbox.org/
     */
    //========================================================================================================================
    require_once(BASE_LIB.'/AjaxView.php');

    class A1010_A extends AjaxView {
        //-------------------------------------------------------------------------------------------------------------------
        /**
         * コンストラクタ/デストラクタ
         *
         * @param object    $application  アプリケーションオブジェクト
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function __construct($application){
            parent::__construct($application);
        }

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * Ajaxサーバーサイドメソッド実行サンプル
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function drawA1010(){
            //A1010:Ajaxクライアント用ビューオブジェクト生成
            require_once(BASE_APP.'/A1010_S.php');
            $wA1010  = new A1010_S($this, $this->_app, 'A1010.tpl.html', 'AJAX');
            $this->addClientView($wA1010, 'frame');

            //クライアント用ビュー実行
            $wA1010->main();    //クライアントビューを描画する処理メソッド(任意)をコールする

            //Ajaxビュー拡張処理記述
            $this->addClientProc("alert('Client side script execute Test');"); //クライアント側で実行するスクリプトがあれば追加
        }

        public function downloadCSV(){
            // CSVファイル名設定
            $wkFileName = date('YmdHis', time());
            $wkFileName = 'Log-'.$wkFileName.'.csv';
            $wkFileName = mb_convert_encoding($wkFileName, 'SJIS-win', 'UTF-8');
            
            // HTML HEADER設定
            header('Content-Disposition: attachment; filename='.$wkFileName);
            header('Content-type: application/x-csv');
            $out = fopen('php://output', 'w');
            fputcsv($out, array($this->request('test')));
            fclose($out);
            die();
        }

        public function RESET_click(){
            $this->_app->lbSession()->reset();
        }
    }

?>
