<?php
    //========================================================================================================================
    /**
     * Webアプリケーション：ビューサンプル実装
     *
     * LICENSE: This source file is subject to GNU GENERAL PUBLIC LICENSE Version 3
     * http://www.gnu.org/licenses/gpl-3.0.txt.
     *
     * @package    SampleApps
     * @subpackage A1000
     * @copyright  2010 LabbitBox Development Team.
     * @license    GPL v3 http://www.gnu.org/licenses/gpl-3.0.txt
     * @author     neobaba <neobaba@labbitbox.org>
     * @version    v0.1
     * @since      -
     * @link       http://labbitbox.org/
     * @see        http://labbitbox.org/
     */
    //========================================================================================================================
    require_once(BASE_LIB.'/EmbededView.php');

    class A1010_S extends EmbededView {
        //-------------------------------------------------------------------------------------------------------------------
        /**
         * コンストラクタ/デストラクタ
         *
         * @param object    $application  アプリケーションオブジェクト
         */
        //-------------------------------------------------------------------------------------------------------------------
/*
        public function __construct($parent, $application, $templateName = ''){
df(__CLASS__.' ->'.__FUNCTION__.'('.__LINE__.'):'.'A1010_Sだよ!1');
            parent::__construct($parent, $application, $templateName);
df(__CLASS__.' ->'.__FUNCTION__.'('.__LINE__.'):'.'A1010_Sだよ!2');

            //$this->setTemplate(BASE_APP.'/A1010.tpl.html');
        }
 */
        //-------------------------------------------------------------------------------------------------------------------
        /**
         * HTMLページ初期生成処理
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function main(){
            //---------------------------------------------------------------------------------------------
            //  Javascriptライブラリ定義
            //---------------------------------------------------------------------------------------------
            /*
            $this->addJsInclude(JS_LIB_DIR.'/prototype.js');
            $this->addJsInclude(JS_LIB_DIR.'/labbitbox.js');
            $this->addJsInclude(JS_LIB_DIR.'/htmlGrid.js');
             */

            //---------------------------------------------------------------------------------------------
            //  プログラム個別Javascript定義
            //---------------------------------------------------------------------------------------------
            $this->addJsInclude(JS_DIR.'/A1010.js');
            
            //---------------------------------------------------------------------------------------------
            //  エレメント編集
            //---------------------------------------------------------------------------------------------
            $this->editStyles();
            $this->editElements();
        }
        
        //-------------------------------------------------------------------------------------------------------------------
        /**
         * スタイル定義編集
         */
        //-------------------------------------------------------------------------------------------------------------------
        private function editStyles(){
            $this->addCssLink('A1010', 'css');

            //<head>タグにスタイル定義の記述を追加
            $this->addStyleCss('.test_class1', array('width' => '100px', 'height' => '100px', 'background-color' => 'green'));
        }
        
        //-------------------------------------------------------------------------------------------------------------------
        /**
         * エレメント編集
         */
        //-------------------------------------------------------------------------------------------------------------------
        private function editElements(){
            require_once(BASE_LIB.'/ModifyElement.php');
            require_once(BASE_LIB.'/HtmlGrid.php');

            //------------------------------------------------------------
            //Ajaxイベント
            $testButton1 = new ModifyElement($this, 'MODIFY');
            //$wEvent = $testButton1->onHttpClick();
            $wEvent = $testButton1->onHttpClick_debugReq();
            //URI指定
            //$wEvent->execParam('uri', 'http://localhost/index.php?action=A1010&method=downloadCSV&type=ajax');
            //LabbitBox標準呼び出し
            //$wEvent->execParam('url', 'http://localhost/A1000.php');
            $wEvent->execParam('action', 'A1010');
            $wEvent->execParam('method', 'downloadCSV');
            $wEvent->execParam('type', 'ajax');
            $wEvent->execParam('test', 'xxxx');
            $wEvent->sendElement(array('txtTest'));

            //$wEvent->execParam(array('method' => 'downloadCSV'));
            //$wEvent->execParam(array('type' => 'html'));
            //$wEvent = $testButton1->onAjaxClick_debugReq();
            //$wEvent->execParam(array('action' => 'A1010'));

            $testButton2 = new ModifyElement($this, 'RESET');
            //$wEvent2 = $testButton1->onAjaxClick();
            $wEvent2 = $testButton2->onAjaxClick_debugReq();

            $testColumns    = array();
            $testColumns[]  = array('header' => '項目１', 'width' =>  80, 'dataIndex' => 'A');
            $testColumns[]  = array('header' => '項目２', 'width' =>  60, 'dataIndex' => 'B', 'xtype' => 'input', 'xconfig' => array('type' => 'button'));
            $testColumns[]  = array('header' => '項目３', 'width' => 100, 'dataIndex' => 'C');
            $testColumns[]  = array('header' => '項目４', 'width' => 120, 'dataIndex' => 'D');
            $gridFormat     = array('width' => 350, 'height' => 150, 'columns' => $testColumns);
        
            $testData       = array();
            $testData[]     = array('A'=>1,'B'=>10,'C'=>100,'D'=>1000);
            $testData[]     = array('A'=>2,'B'=>20,'C'=>200,'D'=>2000);
            $testData[]     = array('A'=>3,'B'=>30,'C'=>300,'D'=>3000);
            $testData[]     = array('A'=>1,'B'=>10,'C'=>100,'D'=>1000);
            $testData[]     = array('A'=>2,'B'=>20,'C'=>200,'D'=>2000);
            $testData[]     = array('A'=>3,'B'=>30,'C'=>300,'D'=>3000);

            $grid1  = new HtmlGrid('GRID1', $testData, $gridFormat);
            $grid1->headStyle('A', 'background-color', 'gray');
            $grid1->colStyle('B', 'color', 'blue');
            $grid1->colStyle('C', 'background-color', 'yellow');
            $grid1->scroll(TRUE);
            $grid1->fixedColCount(1);
            $grid1->replace($this, 'TEST_GRID');
            //$grid1->onClick();
            $wEvent = $grid1->onGridAjaxClick_debugReq();
            $wEvent->gridColumn('B');
        }
   }

?>
