<?php
    //========================================================================================================================
    /**
     * Webアプリケーション：ビューサンプル実装
     *
     * LICENSE: This source file is subject to GNU GENERAL PUBLIC LICENSE Version 3
     * http://www.gnu.org/licenses/gpl-3.0.txt.
     *
     * @package    SampleApps
     * @subpackage A1000
     * @copyright  2010 LabbitBox Development Team.
     * @license    GPL v3 http://www.gnu.org/licenses/gpl-3.0.txt
     * @author     neobaba <neobaba@labbitbox.org>
     * @version    v0.1
     * @since      -
     * @link       http://labbitbox.org/
     * @see        http://labbitbox.org/
     */
    //========================================================================================================================
    require_once(BASE_LIB.'/ClientView.php');

    class A1020_S extends ClientView {
        //-------------------------------------------------------------------------------------------------------------------
        /**
         * コンストラクタ/デストラクタ
         *
         * @param object    $application  アプリケーションオブジェクト
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function __construct($application, $templateName = ''){
           parent::__construct($application, $templateName);
        }

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * HTMLページ初期生成処理
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function main(){
            //---------------------------------------------------------------------------------------------
            //  Javascriptライブラリ定義
            //---------------------------------------------------------------------------------------------
            /*
            $this->addJsInclude(JS_LIB_DIR.'/prototype.js');
            $this->addJsInclude(JS_LIB_DIR.'/labbitbox.js');
            $this->addJsInclude(JS_LIB_DIR.'/htmlGrid.js');
             */

            //---------------------------------------------------------------------------------------------
            //  プログラム個別Javascript定義
            //---------------------------------------------------------------------------------------------
            $this->addJsInclude(JS_DIR.'/A1020.js');
            
            //---------------------------------------------------------------------------------------------
            //  エレメント編集
            //---------------------------------------------------------------------------------------------
            $this->editStyles();
            $this->editElements();
        }
        
        //-------------------------------------------------------------------------------------------------------------------
        /**
         * スタイル定義編集
         */
        //-------------------------------------------------------------------------------------------------------------------
        private function editStyles(){
            $this->addCssLink('A1020', 'css');

            //<head>タグにスタイル定義の記述を追加
            $this->addStyleCss('.test_class1', array('width' => '100px', 'height' => '100px', 'background-color' => 'green'));
        }
        
        //-------------------------------------------------------------------------------------------------------------------
        /**
         * エレメント編集
         */
        //-------------------------------------------------------------------------------------------------------------------
        private function editElements(){
            require_once(BASE_LIB.'/ModifyElement.php');
            require_once(BASE_LIB.'/HtmlGrid.php');

            //------------------------------------------------------------
            //Ajaxイベント
            $testButton1 = new ModifyElement($this, 'MODIFY');
            $wEvent = $testButton1->onClick();
            //$wEvent = $testButton1->onAjaxClick_debugReq();
            //$wEvent->serverList(array('action' => 'A1020'));

            $testColumns    = array();
            $testColumns[]  = array('header' => '項目Ａ', 'width' =>  80, 'dataIndex' => 'A');
            $testColumns[]  = array('header' => '項目Ｂ', 'width' =>  60, 'dataIndex' => 'B');
            $testColumns[]  = array('header' => '項目Ｃ', 'width' => 100, 'dataIndex' => 'C');
            $testColumns[]  = array('header' => '項目Ｄ', 'width' => 120, 'dataIndex' => 'D');
            $gridFormat     = array('width' => 350, 'height' => 150, 'columns' => $testColumns);
        
            $testData       = array();
            $testData[]     = array('A'=>1,'B'=>10,'C'=>100,'D'=>1000);
            $testData[]     = array('A'=>2,'B'=>20,'C'=>200,'D'=>2000);
            $testData[]     = array('A'=>3,'B'=>30,'C'=>300,'D'=>3000);
            $testData[]     = array('A'=>1,'B'=>10,'C'=>100,'D'=>1000);
            $testData[]     = array('A'=>2,'B'=>20,'C'=>200,'D'=>2000);
            $testData[]     = array('A'=>3,'B'=>30,'C'=>300,'D'=>3000);

            $grid1  = new HtmlGrid('GRID1', $testData, $gridFormat);
            $grid1->headStyle('A', 'background-color', 'gray');
            $grid1->colStyle('B', 'color', 'blue');
            $grid1->colStyle('C', 'background-color', 'yellow');
            $grid1->scroll(TRUE);
            $grid1->fixedColCount(1);
            $grid1->replace($this, 'TEST_GRID');
            $grid1->onClick();

         }
   }

?>
