<?php
    //========================================================================================================================
    /**
     * Webアプリケーション：音声再生サンプル実装
     *
     * LICENSE: This source file is subject to GNU GENERAL PUBLIC LICENSE Version 3
     * http://www.gnu.org/licenses/gpl-3.0.txt.
     *
     * @package    SampleApps
     * @subpackage A1030
     * @copyright  2010 LabbitBox Development Team.
     * @license    GPL v3 http://www.gnu.org/licenses/gpl-3.0.txt
     * @author     neobaba <neobaba@labbitbox.org>
     * @version    v0.1
     * @since      -
     * @link       http://labbitbox.org/
     * @see        http://labbitbox.org/
     */
    //========================================================================================================================
    require_once(BASE_LIB.'/AjaxView.php');

    class A1030_A extends AjaxView {
        //-------------------------------------------------------------------------------------------------------------------
        /**
         * コンストラクタ/デストラクタ
         *
         * @param object    $application  アプリケーションオブジェクト
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function __construct($application){
            parent::__construct($application);
        }

        public function magick(){
            $this->addModifyAttr('IMAGE', 'src', 'images/diagram.png?'.date('su'));
        }

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * Ajaxサーバーサイドメソッド実行サンプル
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function main(){
            //A1030:Ajaxクライアント用ビューオブジェクト生成
            require_once(BASE_APP.'/A1030_S.php');
            $wA1030  = new A1030_S($this->_app, 'A1030.tpl.html');
            $this->addClientView($wA1030, 'frame');

            //クライアント用ビュー実行
            $wA1030->main();    //クライアントビューを描画する処理メソッド(任意)をコールする
return;
            //Ajaxビュー拡張処理記述
            $wDialog    = array();
            $wDialog[]  = "ele = document.createElement('div');";
            $wDialog[]  = "ele.style.position='absolute';";
            $wDialog[]  = "ele.style.left='0px';ele.style.top='0px';";
            $wDialog[]  = "ele.style.width='100%';ele.style.height='100%';";
            $wDialog[]  = "ele.style.border='1px solid gray';";
            $wDialog[]  = "ele.style.backgroundColor='silver';";
            $wDialog[]  = "ele.style.filter='alpha(opacity=70)';ele.style.opacity='.70';";

            $wDialog[]  = "str = document.createTextNode('あいうえお');";
            $wDialog[]  = "ele.appendChild(str);";

            $wDialog[]  = "dlg = document.createElement('div');";
            $wDialog[]  = "dlg.style.position='absolute';";
            $wDialog[]  = "dlg.style.left='50%';dlg.style.top='50%';";
            $wDialog[]  = "dlg.style.width='20%';dlg.style.height='20%';";
            $wDialog[]  = "dlg.style.border='1px solid gray';";
            $wDialog[]  = "dlg.style.backgroundColor='yellow';";
            //$wDialog[]  = "dlg.style.filter='alpha(opacity=70)';ele.style.opacity='.70';";
            $wDialog[]  = "ele.appendChild(dlg);";

            $wDialog[]  = "var body = document.getElementsByTagName('body')[0];";
            $wDialog[]  = "body.appendChild(ele);";
            $wDialog[]  = "confirm('test');";
            $this->addClientProc(implode('', $wDialog));
            //$this->addClientProc("");            
            //$this->addClientProc("");

        }

        public function mail(){
            require_once(BASE_LIB.'/EMail.php');
            $wMail  = new EMail('baba@neoworld.co.jp', 'nwba@neoworld.co.jp', $this->request()->get('test'));
            $wMail->addMailHeader('ccAddr', 'nwba@neoworld.co.jp');
            $wMail->send('メールの送信テスト');
        }
        
    }

?>
