<?php
    //========================================================================================================================
    /**
     * Webアプリケーション：ビューサンプル実装
     *
     * LICENSE: This source file is subject to GNU GENERAL PUBLIC LICENSE Version 3
     * http://www.gnu.org/licenses/gpl-3.0.txt.
     *
     * @package    SampleApps
     * @subpackage A1000
     * @copyright  2010 LabbitBox Development Team.
     * @license    GPL v3 http://www.gnu.org/licenses/gpl-3.0.txt
     * @author     neobaba <neobaba@labbitbox.org>
     * @version    v0.1
     * @since      -
     * @link       http://labbitbox.org/
     * @see        http://labbitbox.org/
     */
    //========================================================================================================================
    require_once(BASE_LIB.'/ClientView.php');

    class A1030_S extends ClientView {
        //-------------------------------------------------------------------------------------------------------------------
        /**
         * コンストラクタ/デストラクタ
         *
         * @param object    $application  アプリケーションオブジェクト
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function __construct($application, $templateName = ''){
           parent::__construct($application, $templateName);
        }

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * HTMLページ初期生成処理
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function main(){
            //---------------------------------------------------------------------------------------------
            //  プログラム個別Javascript定義
            //---------------------------------------------------------------------------------------------
            $this->addJsInclude(JS_LIB_DIR.'/sound.js');
            $this->addJsInclude(JS_LIB_DIR.'/canvas.js');
            $this->addJsInclude(JS_DIR.'/A1030.js');
            
            //---------------------------------------------------------------------------------------------
            //  エレメント編集
            //---------------------------------------------------------------------------------------------
            $this->editStyles();
            $this->editElements();
        }
        
        //-------------------------------------------------------------------------------------------------------------------
        /**
         * スタイル定義編集
         */
        //-------------------------------------------------------------------------------------------------------------------
        private function editStyles(){

        }

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * エレメント編集
         */
        //-------------------------------------------------------------------------------------------------------------------
        private function editElements(){
            require_once(BASE_LIB.'/ModifyElement.php');

            $testButton1 = new ModifyElement($this, 'PLAY');
            $testButton1->onClick();

            $wCanvasButton = new ModifyElement($this, 'CV');
            $wCanvasButton->onClick();
 
            $wMailButton = new ModifyElement($this, 'MAIL');
            $wEvent = $wMailButton->onAjaxClick_debugReq();
            $wEvent->sendElement('SUBJECT');
            $wEvent->execParam('method', 'mail'); 
            $wEvent->execParam('test', 'Text'); 
            
            require_once(BASE_LIB.'/HtmlElement.php');
            $wDoc   = new DOMDocument(); 
            $wDoc->loadHTML('<div id="aa"></div>');
            $wContainer    = $wDoc->firstChild;
            $wDiv   = $wDoc->createElement('div');
            $wContainer->appendChild($wDiv);
            //$wDiv   = new HtmlElement('TEST_DIV', 'div', array('style' => 'border:1px solid gray'));
df('-->'.$wDoc->saveXML());
 
            $wMagickButton = new ModifyElement($this, 'MAGICK');
            $wEventMk = $wMagickButton->onAjaxClick_debugRes();
            $wEventMk->execParam('method', 'magick'); 
        }
   }

?>
