<?php
    //========================================================================================================================
    /**
     * Webアプリケーション：ビューサンプル実装
     *
     * LICENSE: This source file is subject to GNU GENERAL PUBLIC LICENSE Version 3
     * http://www.gnu.org/licenses/gpl-3.0.txt.
     *
     * @package    SampleApps
     * @subpackage B1000
     * @copyright  2010 LabbitBox Development Team.
     * @license    GPL v3 http://www.gnu.org/licenses/gpl-3.0.txt
     * @author     neobaba <neobaba@labbitbox.org>
     * @version    v0.1
     * @since      -
     * @link       http://labbitbox.org/
     * @see        http://labbitbox.org/
     */
    //========================================================================================================================
    require_once(BASE_LIB.'/HtmlView.php');

    class B1000_V extends HtmlView {
        //-------------------------------------------------------------------------------------------------------------------
        /**
         * コンストラクタ/デストラクタ
         *
         * @param object    $application  アプリケーションオブジェクト
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function __construct($application){
           parent::__construct($application);
        }

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * HTMLページ初期生成処理
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function editHtml(){
            //---------------------------------------------------------------------------------------------
            //  Javascriptライブラリ定義
            //---------------------------------------------------------------------------------------------
            $this->addJsInclude(JS_LIB_DIR.'/prototype.js');
            $this->addJsInclude(JS_LIB_DIR.'/labbitbox.js');
            //$this->addJsInclude(JS_LIB_DIR.'/htmlGrid.js');
            
            //---------------------------------------------------------------------------------------------
            //  プログラム個別Javascript定義
            //---------------------------------------------------------------------------------------------
            $this->addJsInclude(JS_DIR.'/B1000.js');
            
            //---------------------------------------------------------------------------------------------
            //  エレメント編集
            //---------------------------------------------------------------------------------------------
            $this->editStyles();
            $this->editElements();
        }
        
        //-------------------------------------------------------------------------------------------------------------------
        /**
         * スタイル定義編集
         */
        //-------------------------------------------------------------------------------------------------------------------
        private function editStyles(){
            $this->addCssLink('exTop', 'css');

            //<head>タグにスタイル定義の記述を追加
            $this->addStyleCss('.test_B1000', array('width' => '100px', 'height' => '100px', 'background-color' => 'green'));
        }
        
        //-------------------------------------------------------------------------------------------------------------------
        /**
         * エレメント編集
         */
        //-------------------------------------------------------------------------------------------------------------------
        private function editElements(){
            require_once(BASE_LIB.'/ModifyElement.php');

            //汎用イベント
            $testButton1 = new ModifyElement($this, 'MENU1');
            $testButton1->onClick();

            //--------------------------------------------------------------------------------
            //  従属リージョンを追加する
            //--------------------------------------------------------------------------------
            //従来型リージョン
            $wRegion    = new Region(BASE_APP.'/B1100.tpl.html');
            $this->replaceRegion($wRegion, 'embed1');
            $wCaption1  = new HtmlElement('TITLE1', 'div', array('リージョン埋め込み'));
            $wRegion->displaceElement($wCaption1, 'EM1TEXT');

            //embeded型リージョン
            require_once(BASE_APP.'/B1200_S.php');
            $wB1200   = new B1200_S($this, $this->_app, 'B1200.tpl.html', 'REGION');
            $wB1200->appendPrefix('P01');
            $wB1200->appendSuffix('YY');
            $wB1200->main();
            $this->replaceRegion($wB1200, 'embed2');

            //--------------------------------------------------------------------------------
            //  サイト構造取得(structure.xml)
            //--------------------------------------------------------------------------------
            require_once(BASE_LIB.'/SiteMap.php');
            $wSiteMap   = new SiteMap(BASE_CONF);
//ec($wSiteMap->getNodeByLevel('L300000')->getAttribute('id').':'.$wSiteMap->getTitle('L300000'));
//print_r($wSiteMap->requestInfo('L410000'));
//print_r($wSiteMap->getSiteTree('L410000'));
            print_r($wSiteMap->getBreadcrumbList('L410000', array('galary_no' => 'neo')));
        }
    }

?>
