<?php
    //========================================================================================================================
    /**
     * Webアプリケーション：ビューサンプル実装
     *
     * LICENSE: This source file is subject to GNU GENERAL PUBLIC LICENSE Version 3
     * http://www.gnu.org/licenses/gpl-3.0.txt.
     *
     * @package    SampleApps
     * @subpackage B1200
     * @copyright  2010 LabbitBox Development Team.
     * @license    GPL v3 http://www.gnu.org/licenses/gpl-3.0.txt
     * @author     neobaba <neobaba@labbitbox.org>
     * @version    v0.1
     * @since      -
     * @link       http://labbitbox.org/
     * @see        http://labbitbox.org/
     */
    //========================================================================================================================
    require_once(BASE_LIB.'/EmbededView.php');

    class B1200_S extends EmbededView {
        //-------------------------------------------------------------------------------------------------------------------
        /**
         * HTMLページ初期生成処理
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function main(){
            //---------------------------------------------------------------------------------------------
            //  プログラム個別Javascript定義
            //---------------------------------------------------------------------------------------------
            $this->addJsInclude(JS_DIR.'/B1200.js');
            
            //---------------------------------------------------------------------------------------------
            //  エレメント編集
            //---------------------------------------------------------------------------------------------
            $this->editStyles();
            $this->editElements();
        }
        
        //-------------------------------------------------------------------------------------------------------------------
        /**
         * スタイル定義編集
         */
        //-------------------------------------------------------------------------------------------------------------------
        private function editStyles(){
            $this->addCssLink('B1200', 'css');

            //<head>タグにスタイル定義の記述を追加
            $this->addStyleCss('.test_B1200', array('width' => '100px', 'height' => '100px', 'background-color' => 'green'));
        }
        
        //-------------------------------------------------------------------------------------------------------------------
        /**
         * エレメント編集
         */
        //-------------------------------------------------------------------------------------------------------------------
        private function editElements(){
            require_once(BASE_LIB.'/ModifyElement.php');

            //------------------------------------------------------------
            //Ajaxイベント
            /*
            $testButton1 = new ModifyElement($this, 'MODIFY');
            //$wEvent = $testButton1->onHttpClick();
            $wEvent = $testButton1->onHttpClick_debugReq();
             */

            $wCaption2  = new HtmlElement('TITLE2', 'div', array('別ファイルエンベッド埋め込み'));
            $wRegion2   = new ModifyElement($this, 'b1200');
            $wRegion2->attribute('id', 'ModifyTEST'); 
            $this->displaceElement($wCaption2, 'EM2TEXT');
            
            //embeded型リージョン
            require_once(BASE_APP.'/B1210_S.php');
            $wB1210 = new B1210_S($this, $this->_app, 'B1210.tpl.html');
            $wB1210->appendPrefix('NEO');
            $wB1210->appendSuffix('XX');
            $wB1210->main();
            $wB1    = new ModifyElement($this, 'contents');
            //$wB1->onClick();
            $wB1->onAjaxClick(array(), array(), array('beforeParamSet' => 'checkTarget'));
            $this->displaceRegion($wB1210, 'EM21DIV');
        }
   }

?>
