<?php
    //========================================================================================================================
    /**
     * Webアプリケーション：Ajax用ビューサンプル実装
     *
     * LICENSE: This source file is subject to GNU GENERAL PUBLIC LICENSE Version 3
     * http://www.gnu.org/licenses/gpl-3.0.txt.
     *
     * @package    SampleApps
     * @subpackage Smp2
     * @copyright  2010 LabbitBox Development Team.
     * @license    GPL v3 http://www.gnu.org/licenses/gpl-3.0.txt
     * @author     neobaba <neobaba@labbitbox.org>
     * @version    v0.1
     * @since      -
     * @link       http://labbitbox.org/
     * @see        http://labbitbox.org/
     */
    //========================================================================================================================
    require_once(BASE_LIB.'/AjaxView.php');

    class Smp2_A extends AjaxView {
        //-------------------------------------------------------------------------------------------------------------------
        /**
         * コンストラクタ/デストラクタ
         *
         * @param object    $application  アプリケーションオブジェクト
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function __construct($application){
            parent::__construct($application);
        }

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * Ajaxサーバーサイドメソッド実行サンプル
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function b2_click(){
            ec('b2_click test');
            print_r($_REQUEST);
        }

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * Ajaxサーバーサイドメソッド実行サンプル
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function b2_sever(){
            $this->addAjaxResponse('t1', 'Ajaxイベント処理');   //テキストボックス
            $this->addAjaxResponse('x1', true);                 //チェックボックス
            $this->addAjaxResponse('s2', array(1, 2));          //リストボックス
            $this->addAjaxResponse('r3', true);                 //ラジオボタン
            $this->addModifyAttr('r3', 'test', '3.php');
            return;
            $this->appendElement('testForm', 'form');
            $this->addModifyAttr('testForm', 'action', 'sample3.php');
            $this->addModifyAttr('testForm', 'method', 'post');
            $this->appendElement('action', 'input', 'sample3', 'testForm');
            $this->addModifyAttr('action', 'type', 'hidden');
            $this->addClientProc("$('testForm').submit();");

        }

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * Ajaxサーバーサイドメソッド実行サンプル
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function b5_click(){
            $this->addAjaxResponse('t1', 'リストボックスアイテム変更');
            $this->addAjaxReplaceSelect('s1', array('new1' => 10, 'new2' => 20, 'new3' => 30), 20); //単一選択状態
            //$this->addAjaxReplaceSelect('s2', array('new1' => 10, 'new2' => 20, 'new3' => 30));   //選択状態なし
            $this->addAjaxReplaceSelect('s2', array('new1' => 10, 'new2' => 20, 'new3' => 30), array(10, 30));  //複数選択状態
        }

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * Ajaxサーバーサイドメソッド実行サンプル
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function s1_change(){
            $this->addAjaxResponse('s2', $this->_app->request('s1'));
       }

        public function s2_change(){
            $this->addAjaxResponse('s1', $this->_app->request('s2'));
       }
    }

?>
