<?php
    //========================================================================================================================
    /**
     * Webアプリケーション：ビューサンプル実装
     *
     * LICENSE: This source file is subject to GNU GENERAL PUBLIC LICENSE Version 3
     * http://www.gnu.org/licenses/gpl-3.0.txt.
     *
     * @package    SampleApps
     * @subpackage Smp2
     * @copyright  2010 LabbitBox Development Team.
     * @license    GPL v3 http://www.gnu.org/licenses/gpl-3.0.txt
     * @author     neobaba <neobaba@labbitbox.org>
     * @version    v0.1
     * @since      -
     * @link       http://labbitbox.org/
     * @see        http://labbitbox.org/
     */
    //========================================================================================================================
    require_once(BASE_LIB.'/HtmlView.php');
    require_once(BASE_LIB.'/HtmlTableGrid.php');

    class Smp2_V extends HtmlView {
        //-------------------------------------------------------------------------------------------------------------------
        /**
         * コンストラクタ/デストラクタ
         *
         * @param object    $application  アプリケーションオブジェクト
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function __construct($application){
           parent::__construct($application);
        }

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * HTMLページ初期生成処理
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function editHtml(){
            //---------------------------------------------------------------------------------------------
            //  Javascriptライブラリ定義
            //---------------------------------------------------------------------------------------------
            $this->addJsInclude(JS_LIB_DIR.'/prototype.js');
            $this->addJsInclude(JS_LIB_DIR.'/labbitbox.js');
            $this->addJsInclude(JS_LIB_DIR.'/htmlGrid.js');
            
            //---------------------------------------------------------------------------------------------
            //  プログラム個別Javascript定義
            //---------------------------------------------------------------------------------------------
            $this->addJsInclude(JS_DIR.'/sample2.js');
            
            //---------------------------------------------------------------------------------------------
            //  エレメント編集
            //---------------------------------------------------------------------------------------------
            $this->editStyles();
            $this->editElements();
        }
        
        //-------------------------------------------------------------------------------------------------------------------
        /**
         * スタイル定義編集
         */
        //-------------------------------------------------------------------------------------------------------------------
        private function editStyles(){
            $this->addCssLink('a1010', 'css');

            //<head>タグにスタイル定義の記述を追加
            $this->addStyleCss('.test_class1', array('width' => '100px', 'height' => '100px', 'background-color' => 'green'));
        }
        
        //-------------------------------------------------------------------------------------------------------------------
        /**
         * エレメント編集
         */
        //-------------------------------------------------------------------------------------------------------------------
        private function editElements(){
            require_once(BASE_LIB.'/ModifyElement.php');

            $this->addMeta('test', '123');

            //------------------------------------------------------------
            //タイトル変更
            $windowTitle    = new ModifyElement($this, 'TITLE');
            $windowTitle->text('test');

            //--------------------------------------------------------------------------------
            //  従属リージョンを追加する
            //--------------------------------------------------------------------------------
            $childRegion    = new Region(BASE_APP.'/topChild.tpl.html');    //別テンプレートのリージョン
            $this->displaceRegion($childRegion, 'TEST_DIV1');               //親リージョンに子リージョンオブジェクトを追加
            
            $textTest1  = new TextNode('prefix');
            $textTest2  = new HtmlElement('TEXT_TEST2', 'div', 'textTest2');
            $textTest3  = new TextNode('suffix');
            $this->appendElement($textTest1);
            $this->appendElement($textTest2);
            $this->appendElement($textTest3);
            
            //--------------------------------------------------------------------------------
            //  テンプレート定義にエレメントを追加する
            //--------------------------------------------------------------------------------
            require_once(BASE_LIB.'/HtmlElement.php');
            
            //追加するエレメントを生成し属性も定義する
            $taro       = new HtmlElement('TARO', 'img', array('src' => 'images/taro.gif'));
            $taro->style(array('position' => 'absolute', 'left' => '-20px'));

            //追加するエレメントを生成
            $title      = new HtmlElement('TITLE', 'div', array('ここはテンプレートに後から追加'));
            $title->style('font-size', '14px');
            $listbox    = new HtmlElement('TEST_LIST', 'select', array('multiple' => ''));
            $option1    = new HtmlElement('OPTION1', 'option', array('test50', 'value' => 50));
            $option2    = new HtmlElement('OPTION2', 'option', array('test60', 'value' => 60));
            $option2->attribute('selected');
            $option3    = new HtmlElement('OPTION3', 'option', array('test70', 'value' => 70));
            $button1    = new HtmlElement('TEST_BTN', 'input', array('type' => 'button', 'value' => '追加ボタン'));
            $button1->style('width', '200px');
    
            //親リージョンにエレメントを追加
            $childRegion->appendElement($title, 'CHILD_DIV');
            $childRegion->appendElement($listbox, 'CHILD_DIV');
            $childRegion->appendElement($option1, 'TEST_LIST');
            $childRegion->appendElement($option2, 'TEST_LIST');
            $childRegion->appendElement($option3, 'TEST_LIST');
            $childRegion->appendElement($button1, 'CHILD_DIV');

            $this->appendElement($taro, 'TEST_DIV2');

            //--------------------------------------------------------------------------------
            //テンプレート定義された内容を変更する
            //--------------------------------------------------------------------------------
            $testDiv2   = new ModifyElement($this, 'TEST_DIV2');
            $testDiv2->style('overflow', 'hidden');
            $testDiv2->style(array('position' => 'absolute', 'width' => '200px', 'height' => '200px', 'left' => '250px', 'top' => '420px'));
            $testDiv2->style(array('border-width' => '1px', 'border-style' => 'solid'));

            $testText1  = new ModifyElement($this, 't1');
            $testText1->style(array('width' => '200px', 'background-color' => 'silver'));

            //--------------------------------------------------------------------------------
            //イベントを追加
            //--------------------------------------------------------------------------------
            //汎用イベント
            $testButton1 = new ModifyElement($this, 'b1');
            $testButton1->onClick();
            
            //------------------------------------------------------------
            //Ajaxイベント
            $testButton2 = new ModifyElement($this, 'b2');
            //$testButton2->onAjaxClick(array('t1', 't2', 's1', 'x1', 'r1', 'r2', 'r3', 'ta'), array('method' => 'b2_sever'));
            $testButton2->onAjaxClick(array(), array('method' => 'b2_sever'), array('beforeParamSet' => 'aaa'));
            
            //Ajaxイベント（リクエスト デバッグ機能付き）
            $testButton3 = new ModifyElement($this, 'b3');
            $testButton3->onAjaxClick_debugReq(array('t1', 't2', 's1', 'x1', 'r1', 'r2', 'r3', 'ta'), array('method' => 'b2_sever'));
            
            //Ajaxイベント（レスポンス デバッグ機能付き）
            $testButton4 = new ModifyElement($this, 'b4');
            $testButton4->onAjaxClick_debugRes(array('t1', 't2', 's1', 'x1', 'r1', 'r2', 'r3', 'ta'), array('method' => 'b2_sever'));
            
            //------------------------------------------------------------
            //セレクトタグアイテム変更
            $testButton5 = new ModifyElement($this, 'b5');
            $testButton5->onAjaxClick(array('t1', 't2', 's1', 'x1', 'r1', 'r2', 'r3', 'ta'));
            
            //------------------------------------------------------------
            //Ajaxイベント:selectタグ
            $testCombobox1 = new ModifyElement($this, 's1');
            $testCombobox1->onAjaxChange_debugReq(array('s1'));

            $testListobox1 = new ModifyElement($this, 's2');
            $testListobox1->onAjaxChange(array('s2'));
            
            //Ajaxイベント:チェックボックス
            $tesCheckbox2 = new ModifyElement($this, 'x1');
            $tesCheckbox2->onAjaxClick(array('s1'));
            
            //汎用イベント:動的追加ボタン
            $button1->onClick();
            
            //--------------------------------------------------------------------------------
            //拡張コンポーネントを追加
            //--------------------------------------------------------------------------------
            require_once(BASE_LIB.'/Components.php');
            
            //コンボボックス
            $combobox   = new Combobox('TEST_COMBO', array(10 => 'ComboItem1', 20 => 'ComboItem2', 30 => 'ComboItem3'), 20);
            $combobox->style(array('position' => 'absolute', 'left' => '100px'));
            $combobox->append($this, 'TEST_DIV2');
            
            //リストボックス
            $listbox   = new Listbox('TEST_LIST', array(10 => 'ListItem1', 20 => 'ListItem2', 30 => 'ListItem3'), 30);
            $listbox->style(array('position' => 'absolute', 'left' => '100px', 'top' => '100px'));
            $listbox->append($this, 'TEST_DIV2');
        
            //--------------------------------------------------------------------------------
            //グリッドコンポーネントを追加
            //--------------------------------------------------------------------------------
            //テーブルタグ使用グリッド(DOMを使用するため大量データ処理には向かない)
            //グリッド
            $testColumns    = array();
            $testColumns[]  = array('header' => '項目１', 'width' =>  60, 'dataIndex' => 'STATION_NO', 'attribute' => array('align' => 'center'));
            $testColumns[]  = array('header' => '項目２', 'width' => 100, 'dataIndex' => 'STATION_NAME', 'xtype' => 'input', 'xconfig' => array('type' => 'button'));
            $testColumns[]  = array('header' => '項目３', 'width' => 140, 'dataIndex' => 'STATION_NAME_READ');
            $testColumns[]  = array('header' => '項目４', 'width' => 140, 'dataIndex' => 'CREATE_USER', 'xtype' => 'a', 'xconfig' => array('dataIndex' => 'SORT_NO'));
            $testColumns[]  = array('header' => '項目５', 'width' =>  60, 'dataIndex' => 'ENABLED', 'xtype' => 'input', 'xconfig' => array('type' => 'checkbox', 'value' => 'T'));
            $gridFormat     = array('width' => 380, 'height' => 350, 'columns' => $testColumns);

            $grid1      = new HtmlTableGrid('GRID1', $this->_app->shared()->get('DATASOURCE')->getAllAsArray(), $gridFormat);
            $grid1->fixedColCount(1);
            
            $grid1->style(array('position' => 'absolute', 'left' => '5px', 'top' => '5px'));
            $grid1->style('font-size', '12px');
            $grid1->replace($this, 'TEST_DIV3');
            
            //イベント定義(イベントハンドラはGRID1_click())
            $grid1->onClick();
        }
    }

?>
