<?php
    //========================================================================================================================
    /**
     * Webアプリケーション：ビューサンプル グリッド(HtmlGrid/HtmlGridEx)実装
     *
     * LICENSE: This source file is subject to GNU GENERAL PUBLIC LICENSE Version 3
     * http://www.gnu.org/licenses/gpl-3.0.txt.
     *
     * @package    SampleApps
     * @subpackage Smp3
     * @copyright  2010 LabbitBox Development Team.
     * @license    GPL v3 http://www.gnu.org/licenses/gpl-3.0.txt
     * @author     neobaba <neobaba@labbitbox.org>
     * @version    v0.1
     * @since      -
     * @link       http://labbitbox.org/
     * @see        http://labbitbox.org/
     */
    //========================================================================================================================
    require_once(BASE_LIB.'/HtmlView.php');

    class Smp3_V extends HtmlView {
        //-------------------------------------------------------------------------------------------------------------------
        /**
         * コンストラクタ/デストラクタ
         *
         * @param object    $application  アプリケーションオブジェクト
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function __construct($application){
            parent::__construct($application);
        }

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * HTMLページ初期生成処理
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function editHtml(){
            //---------------------------------------------------------------------------------------------
            //  Javascriptライブラリ定義
            //---------------------------------------------------------------------------------------------
            $this->addJsInclude(JS_LIB_DIR.'/prototype.js');
            $this->addJsInclude(JS_LIB_DIR.'/labbitbox.js');
            
            //---------------------------------------------------------------------------------------------
            //  プログラム個別Javascript定義
            //---------------------------------------------------------------------------------------------
            $this->addJsInclude(JS_DIR.'/sample3.js');
            
            //---------------------------------------------------------------------------------------------
            //  エレメント編集
            //---------------------------------------------------------------------------------------------
            $this->editStyles();
            $this->editElements();
        }
        
        //-------------------------------------------------------------------------------------------------------------------
        /**
         * スタイル定義編集
         */
        //-------------------------------------------------------------------------------------------------------------------
        private function editStyles(){
            $this->addCssLink('a1010', 'css');

            //<head>タグにスタイル定義の記述を追加
            $this->addStyleCss('.test_class1', array('width' => '100px', 'height' => '100px', 'background-color' => 'green'));
        }
        
        //-------------------------------------------------------------------------------------------------------------------
        /**
         * エレメント編集
         */
        //-------------------------------------------------------------------------------------------------------------------        
        private function editElements(){
            //--------------------------------------------------------------------------------
            //拡張コンポーネントを追加
            //--------------------------------------------------------------------------------
            require_once(BASE_LIB.'/Components.php');
            require_once(BASE_LIB.'/HtmlGrid.php');
            require_once(BASE_LIB.'/HtmlTableGrid.php');

            //div/Text
            $grid1  = $this->_grid1();
            $grid1->onClick();          //イベント定義(イベントハンドラはGRID1_click())
            //$wEvent = $grid1->onGridAjaxClick_debugReq();
            //$wEvent->gridColumn('STATION_NO');

            //table/DOM
            //$this->_tableGrid();
            //$this->_htmlTableGrid();
        }
        
        //------------------------------------------------------------------------------------------------------------
        private function gridFormat(){
            $testColumns    = array();
            $testColumns[]  = array('header' => '項目１', 'width' =>  80, 'dataIndex' => 'SORT_NO', 'xtype' => 'combobox', 'xconfig' => array('options' => array('9' => 'TEST1', '10' => 'TEST2')));
            $testColumns[]  = array('header' => '項目２', 'width' =>  60, 'dataIndex' => 'STATION_NO', 'xtype' => 'input', 'xconfig' => array('type' => 'button'));
            $testColumns[]  = array('header' => '項目３', 'width' => 100, 'dataIndex' => 'STATION_NAME_READ', 'colStyle' => array('color' => 'red'), 'headStyle' => array('color' => 'blue'));
            $testColumns[]  = array('header' => '項目４', 'width' => 100, 'dataIndex' => 'STATION_NAME', 'xtype' => 'input', 'xconfig' => array('type' => 'text'));
            $testColumns[]  = array('header' => '項目５', 'width' =>  60, 'dataIndex' => 'ENABLED', 'xtype' => 'input', 'xconfig' => array('type' => 'checkbox', 'value' => 'T'));
            $testColumns[]  = array('header' => '項目６', 'width' =>  80, 'dataIndex' => 'CREATE_USER', 'xtype' => 'a', 'xconfig' => array('dataIndex' => 'SORT_NO'));
            $gridFormat     = array('width' => 450, 'height' => 350, 'columns' => $testColumns);
            return $gridFormat;
        }

        //------------------------------------------------------------------------------------------------------------
        //div使用グリッド
        private function _grid1(){            
            //グリッドフォーマット取得
            $gridFormat = $this->gridFormat();

            //グリッド編集
            $element    = new HtmlElement('APPEND_TEST', 'div', array('border' => '1px solid red'));
            $this->appendElement($element);

            $grid1  = new HtmlGrid('GRID1', $this->_app->shared()->get('DATASOURCE1')->getAllAsArray(), $gridFormat);
            $grid1->style(array('left' => '5px', 'top' => '5px', 'font-size' => '9px'));
            $grid1->headStyle('STATION_NAME', 'background-color', 'gray');
            $grid1->colStyle('STATION_NAME', 'color', 'blue');
            $grid1->headStyle('STATION_NAME_READ', 'background-color', 'pink');
            $grid1->colStyle('STATION_NAME_READ', 'background-color', 'yellow');
            $grid1->scroll(TRUE);
            $grid1->fixedColCount(1);
            $grid1->replace($this, 'htmlGrid1');
            
            //$this->addStyleCss('.GRID1_FIXED_STATION_NO', array('text-align' => 'center'));     //専用のメソッドcolStyle追加済み
            $grid1->colAttr('STATION_NAME', 'test', 1);
            
            //イベント定義(イベントハンドラはGRID1_click())
            return $grid1;
        }
        
        //------------------------------------------------------------------------------------------------------------
        //テーブルタグ使用グリッド(DOMを使用するため大量データ処理には向かない)
        private function _tableGrid(){
            //グリッドフォーマット取得
            $gridFormat = $this->gridFormat();

            //グリッド編集
            $grid1      = new Table('GRID1', $this->_app->shared()->get('DATASOURCE1')->getAllAsArray(), $gridFormat);
            $grid1->headCellAttribute('bgcolor', 'yellow');
            //$grid1->gridCellAttribute('bgcolor', 'pink');
            
            $grid1->style(array('position' => 'absolute', 'left' => '5px', 'top' => '5px'));
            $grid1->style('font-size', '12px');
            //$grid1->style('overflow', 'scroll');
            //$grid1->style('overflow', 'hidden');
            $grid1->replace($this, 'htmlGrid1');
            
            //イベント定義(イベントハンドラはGRID1_click())
            $grid1->onClick();
        }

        //拡張グリッド
        private function _htmlTableGrid(){
            //グリッドフォーマット取得
            $gridFormat = $this->gridFormat();

            //グリッド編集
            $grid2      = new HtmlTableGrid('GRID2', $this->_app->shared()->get('DATASOURCE2')->getAllAsArray(), $gridFormat);
//            $grid2->style('font-size', '12px');
//            $grid2->headCellAttribute('bgcolor', 'orange');
//            $grid2->gridCellAttribute('bgcolor', 'pink');
            $grid2->fixedColCount(1);
            $grid2->style(array('left' => '5px', 'top' => '5px'));
            $grid2->append($this, 'htmlGrid2');
            
        }
    }

?>
