<?php
    //========================================================================================================================
    /**
     * Webアプリケーション：ビューサンプル グリッド(HtmlGrid/HtmlGridEx)実装
     *
     * LICENSE: This source file is subject to GNU GENERAL PUBLIC LICENSE Version 3
     * http://www.gnu.org/licenses/gpl-3.0.txt.
     *
     * @package    SampleApps
     * @subpackage Smp4
     * @copyright  2010 LabbitBox Development Team.
     * @license    GPL v3 http://www.gnu.org/licenses/gpl-3.0.txt
     * @author     neobaba <neobaba@labbitbox.org>
     * @version    v0.1
     * @since      -
     * @link       http://labbitbox.org/
     * @see        http://labbitbox.org/
     */
    //========================================================================================================================
    require_once(BASE_LIB.'/HtmlView.php');

    class Smp4_V extends HtmlView {
        //-------------------------------------------------------------------------------------------------------------------
        /**
         * コンストラクタ/デストラクタ
         *
         * @param object    $application  アプリケーションオブジェクト
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function __construct($application){
            parent::__construct($application);
        }

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * HTMLページ初期生成処理
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function editHtml(){
            //---------------------------------------------------------------------------------------------
            //  Javascriptライブラリ定義
            //---------------------------------------------------------------------------------------------
            $this->addJsInclude(JS_LIB_DIR.'/prototype.js');
            $this->addJsInclude(JS_LIB_DIR.'/labbitbox.js');
            
            //---------------------------------------------------------------------------------------------
            //  プログラム個別Javascript定義
            //---------------------------------------------------------------------------------------------
            $this->addJsInclude(JS_DIR.'/sample4.js');
            
            //---------------------------------------------------------------------------------------------
            //  エレメント編集
            //---------------------------------------------------------------------------------------------
            $this->editStyles();
            $this->editElements();
        }
        
        //-------------------------------------------------------------------------------------------------------------------
        /**
         * スタイル定義編集
         */
        //-------------------------------------------------------------------------------------------------------------------
        private function editStyles(){

        }
        
        //-------------------------------------------------------------------------------------------------------------------
        /**
         * エレメント編集
         */
        //-------------------------------------------------------------------------------------------------------------------
        private function editElements(){
            require_once(BASE_LIB.'/HtmlElement.php');
            require_once(BASE_LIB.'/ModifyElement.php');
          
            $wCaption   = new HtmlElement('caption', 'div', 'こんにちは');
            $this->appendElement($wCaption, 'terop');
            $wCaption->style('position', 'absolute');
            $wCaption->style(array('left' => '150px', 'top' => '0px', 'height' => '40px'));
            $wCaption->style('border', '1px solid red');
            $wCaption->style('background-Color', 'green');
            $wCaption->style('width', '100px');     //
            $wCaption->style('overflow', 'hidden');
            
            //汎用イベント
            $moveButton = new ModifyElement($this, 'move');
            $moveButton->onClick();
  
        }
        
    }

?>
