<?php
    //========================================================================================================================
    /**
     * Webアプリケーション：ビューサンプル実装
     *
     * LICENSE: This source file is subject to GNU GENERAL PUBLIC LICENSE Version 3
     * http://www.gnu.org/licenses/gpl-3.0.txt.
     *
     * @package    SampleApps
     * @subpackage Smp5
     * @copyright  2010 LabbitBox Development Team.
     * @license    GPL v3 http://www.gnu.org/licenses/gpl-3.0.txt
     * @author     neobaba <neobaba@labbitbox.org>
     * @version    v0.1
     * @since      -
     * @link       http://labbitbox.org/
     * @see        http://labbitbox.org/
     */
    //========================================================================================================================
    require_once(BASE_LIB.'/View.php');

    class Smp2_V extends View {
        //-------------------------------------------------------------------------------------------------------------------
        /**
         * コンストラクタ/デストラクタ
         *
         * @param object    $agApplication  アプリケーションオブジェクト
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function __construct($agApplication){
            $this->name             = $agApplication->param('action'); //デバッグ用識別名

            //スーパークラスコンストラクタ
            parent::__construct($agApplication);
        }

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * HTMLページ初期生成処理（コンストラクタよりコールされる)
         *
         * @param object    $agApplication  アプリケーションオブジェクト
         * @param string    $agMode         動作モード 'v':html表示/'a':Ajax表示/'d':Ajax値取得
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function editHtml(){
            //parent::editHtml();

            //<head>タグにスタイル定義の記述を追加
            //$this->addStyleCss('.test_class1', array('width' => '100px', 'height' => '100px', 'background-color' => 'green'));
            //$this->addStyleCssList($this->_navi->getStyleList());
            
            //---------------------------------------------------------------------------------------------
            //  プログラム個別Javascript定義
            //  ※定義順序重要
            //---------------------------------------------------------------------------------------------
            $this->addJsInclude('js/a1010.js');

            //---------------------------------------------------------------------------------------------
            //  ExtJS.ux
            //---------------------------------------------------------------------------------------------
            $this->addJsInclude('js/lib/ux/LockingGridView.js');

            //---------------------------------------------------------------------------------------------
            //  データストア定義
            //  ※定義順序重要
            //---------------------------------------------------------------------------------------------
            $this->addExtDs('DsPacket', 'dsPacket');
            $this->addExtDs('DsTid',    'dsTid');

            //---------------------------------------------------------------------------------------------
            //  ExtJS UI定義
            //  ※定義順序重要
            //---------------------------------------------------------------------------------------------
            $this->addExtUi('Login',            'PANEL_login');
            $this->addExtUi('Logout',           'PANEL_login', FALSE);
            $this->addExtUi('GridPacket',       'GRID_packet');
            $this->addExtUi('GridTid',          'GRID_tid');
            $this->addExtUi('WIN_test');
            
            //---------------------------------------------------------------------------------------------
            //  Javascript定義
            //---------------------------------------------------------------------------------------------
            
            //---------------------------------------------------------------------------------------------
            //  エレメント編集
            //---------------------------------------------------------------------------------------------
            $this->editElements();

            $this->addCssLink('a1010', 'css');

            //direct
            unlink(EXTJS.'/cache/api_cache.txt');
            $cache = new ExtDirect_CacheProvider(EXTJS.'/cache/api_cache.txt');
            $api = new ExtDirect_API();

            $api->setRouterUrl('index.php');
            $api->setCacheProvider($cache);
            $api->setNamespace('Ext.ss');
            $api->setDescriptor('Ext.ss.APIDesc');
            $api->setDefaults(array(
                'autoInclude' => true,
                'basePath' => PRJHOME
            ));
return;
            $api->add(
                array(
//                    'Echo' => array('prefix' => 'Class_'),
//                    'Exception' => array('prefix' => 'Class_'),
//                    'Time',
//                    'File'
                    'A1010M'
                )
            );

            $this->addJsScript($api->getStringApi());
            $this->addJsScript('Ext.Direct.addProvider(Ext.ss.APIDesc);');

            $_SESSION['ext-direct-state'] = $api->getState();
        }
        
        //-------------------------------------------------------------------------------------------------------------------
        /**
         * エレメント編集
         */
        //-------------------------------------------------------------------------------------------------------------------
        private function editElements(){

        }

    }

?>
