<?php
    //========================================================================================================================
    /**
     * Webアプリケーション：プレコントローラサンプル実装
     *
     * LICENSE: This source file is subject to GNU GENERAL PUBLIC LICENSE Version 3
     * http://www.gnu.org/licenses/gpl-3.0.txt.
     *
     * @package    SampleApps
     * @subpackage A1000
     * @copyright  2010 LabbitBox Development Team.
     * @license    GPL v3 http://www.gnu.org/licenses/gpl-3.0.txt
     * @author     neobaba <neobaba@labbitbox.org>
     * @version    v0.1
     * @since      -
     * @link       http://labbitbox.org/
     * @see        http://labbitbox.org/
     */
    //========================================================================================================================
    require_once(BASE_LIB.'/Precontroller.php');
    require_once(BASE_LIB.'/LbSession.php');

    class _precontroller extends Precontroller {
        /**
         * セッション有効時処理
         * @param object    $LbSession  LabbitBoxセッションオブジェクト
         */
        public function sessionActive($lbSession){
            //ログイン済み
            if ($lbSession->get('LOGIN')){
df(__CLASS__.'->'.__FUNCTION__.'('.__LINE__.')'.'Already Login:'.implode('#', $_REQUEST));
            }
            //未ログイン
            else{
df(__CLASS__.'->'.__FUNCTION__.'('.__LINE__.')'.'Not Login');
                //$lbSession->interrupt('Login', 'authorize', 'ajax');
            }
        }

        /**
         * セッション無効時処理
         * @param object    $LbSession  LabbitBoxセッションオブジェクト
         */
        public function sessionInactive($lbSession){
            //CLIチェック
            if (array_key_exists('argc', $_SERVER)){
                $this->_app->request()->set('type', 'cli');
                return; 
            }

df(__CLASS__.'->'.__FUNCTION__.'('.__LINE__.')'.'Inactive');
            $lbSession->interrupt('Login', 'editHtml', 'html');
            $lbSession->setTemplate('Login.tpl.html');
            $lbSession->add('LOGIN', FALSE);
        }
    }

?>
