<?php
    //========================================================================================================================
    /**
     * Webアプリケーション：インデックスファイル実装サンプル
     *
     * LICENSE: This source file is subject to GNU GENERAL PUBLIC LICENSE Version 3
     * http://www.gnu.org/licenses/gpl-3.0.txt.
     *
     * @package    SampleApps
     * @subpackage Smp1
     * @copyright  2010 LabbitBox Development Team.
     * @license    GPL v3 http://www.gnu.org/licenses/gpl-3.0.txt
     * @author     neobaba <neobaba@labbitbox.org>
     * @version    v0.1
     * @since      -
     * @link       http://labbitbox.org/
     * @see        http://labbitbox.org/
     * @todo       !! THIS FILE IS WRITTEN IN OLD STYLE FORMAT !!
     */
    //========================================================================================================================

    ini_set('display_errors',       'on');  //エラー表示ON/OFF
    
    //=============================================================================================
    //  Resionクラスを単独で使用した場合の例
    //=============================================================================================

    //---------------------------------------------------------------------------------------------
    // 初期処理
    //---------------------------------------------------------------------------------------------
    //初期処理
    //-- 以下の規定の定数定義にはインストール時に配置したディレクトリを記述
    define('BASE_CONF', '/Users/pinga/develop/conf');      //設定ファイルディレクトリ
    define('BASE_LIB',  '/Users/pinga/develop/core');      //フレームワークディレクトリ
    define('BASE_APP',  '/Users/pinga/develop/sample');    //アプリケーションディレクトリ

    //---------------------------------------------------------------------------------------------
    // サンプル用メイン処理
    //---------------------------------------------------------------------------------------------
    // プログラム実行
    $wkFunction = 'test'.$_REQUEST['mode'];
    $wkFunction();
    
    //---------------------------------------------------------------------------------------------
    // テンプレートをそのまま表示する例
    //---------------------------------------------------------------------------------------------
    function test1(){
        require_once(BASE_LIB.'/Region.php');
    
        //以下の処理は test2,test3 でも同様
        $wkRegion = new Region(BASE_APP.'/test.tpl.html'); //テンプレートの絶対パスを指定してリージョンオブジェクトを生成
        $wkRegion->response(TRUE);                              //同時出力指定でレスポンス生成
    }
    
    //---------------------------------------------------------------------------------------------
    // テンプレート中にコンボボックスを追加表示する例
    // ※appendElement()で指定したコンテナエレメントの子エレメントとなる
    //---------------------------------------------------------------------------------------------
    function test2(){
        require_once(BASE_LIB.'/Region.php');
        require_once(BASE_LIB.'/HtmlElement.php');
    
        $wkRegion = new Region(BASE_APP.'/sample1.tpl.html');

        //追加するエレメントを生成
        $wkElement  = new HtmlElement('TEST_LIST', 'select', array('multiple' => ''));
        $wkOption1  = new HtmlElement('OPTION1', 'option', array('test1'));
        $wkOption2  = new HtmlElement('OPTION2', 'option', array('test2'));
        $wkOption3  = new HtmlElement('OPTION3', 'option', array('test3'));
    
        //親リージョンにエレメントを追加
        $wkRegion->appendElement($wkElement, 'PANEL_login');
        $wkRegion->appendElement($wkOption1, 'TEST_LIST');
        $wkRegion->appendElement($wkOption2, 'TEST_LIST');
        $wkRegion->appendElement($wkOption3, 'TEST_LIST');
    
        $wkRegion->response(TRUE);                              //同時出力指定でレスポンス生成
    }
    
    //---------------------------------------------------------------------------------------------
    // テンプレート中の別テンプレートのリージョンブロックを追加表示する例
    // ※addChildRegion()で指定したコンテナエレメントを置き換える
    //---------------------------------------------------------------------------------------------
    function test3(){
        require_once(BASE_LIB.'/Region.php');
        require_once(BASE_LIB.'/HtmlElement.php');
    
        $wkRegion   = new Region(BASE_APP.'/sample1.tpl.html');
     
        $wkChild    = new Region(BASE_APP.'/topChild.tpl.html');    //別テンプレートのリージョン
        $wkRegion->appendRegion($wkChild, 'main');                  //親リージョンに子リージョンオブジェクトを追加

        //追加するエレメントを生成
        $wkElement  = new HtmlElement('TEST_COMBO', 'select');
        $wkOption1  = new HtmlElement('OPTION1', 'option', array('test1', 'value' => '55'));
        $wkOption2  = new HtmlElement('OPTION2', 'option', array('test2'));
        $wkOption3  = new HtmlElement('OPTION3', 'option', array('test3'));
    
        //子リージョンにエレメントを追加
        $wkChild->appendElement($wkElement, 'CHILD_DIV');
        $wkChild->appendElement($wkOption1, 'TEST_COMBO');
        $wkChild->appendElement($wkOption2, 'TEST_COMBO');
        $wkChild->appendElement($wkOption3, 'TEST_COMBO');

        //スタイル(タグ埋め込み)設定
        $wkElement->style('width', '120px');
        $wkElement->style(array('height' => '30px', 'color' => 'red'));
 
        $wkRegion->response(TRUE);
    }

?>
