
#pragma once
#include <windows.h>
#include <d3dx9.h>
#include <d3d9.h>
#include <vector>
#include "dxSysDraw.h"
#include "dxSysTexCtrl.h"


typedef struct _LBLGlassPoint : public DrawParts
{
	int				m_id;		//hc
	int				m_vexChain;	//A_
	D3DXVECTOR3		m_vexPos;	//_ʒu
	D3DXVECTOR2		m_vexUV;	//_tu

	VERTEX2D		m_stVexdbg[4];	//_

	void	MakeVertex(float x,float y,float u,float v);
	void	AddPoint(){ m_vexChain++; }
	void	idol();
} LBLGlassPoint;

typedef struct _LBLGlassPoly : public DrawParts
{
	VERTEX			m_stVex[3];	//|S
	D3DXVECTOR3		m_RotPow;	//]̋x

	void	MakeTriangle(LBLGlassPoint* p1, LBLGlassPoint* p2, LBLGlassPoint* p3);
	void	SetGrv(float rg);
	void	Start();
	void	Idol();

} LBLGlassPoly;


class LBLGlass
{
	std::vector<LBLGlassPoint*>	m_stPoint;
	std::vector<LBLGlassPoly*>	m_stPolys;

	LPD3DXMESH	m_pMesh;
	int		m_maxVex;

	int		MakeVertex(float x,float y,float u,float v);
	int		Search(LBLGlassPoint* p);
	void	MakeTriangle(int,int,int);
public:
	LBLGlass(){ m_stPoint.clear(); m_stPolys.clear(); m_maxVex=0; }
	~LBLGlass();

	void	Make();
	void	idol();
};