/*
	Labo.Tamplate.Library
*/

//prF
//	AP[^rAzmۂL[IzɂyAReiȂ
/////////////////////////////////////////////////////////////////////////////////////////

#pragma once
#include <vector>


namespace LTL {

#ifndef SAFE_DELETE
#define SAFE_DELETE(p)       { if(p) { delete (p);     (p)=NULL; } }
#endif    

// Iz ----------------------------------------------------------------------------------


template <class Object>
class LTLArray {

	int			m_size;
	int			m_Objsize;
	int			m_sizespan;
	Object*		m_Array;

	typedef struct _tagAccessItr
	{
		int			nSet;
		Object*		first;
		Object*		now;
		Object*		last;

		_tagAccessItr()
		{
			first = now = last = NULL;
			nSet = 0;
		}

		Object* operator++(int dummy)
		{
			if(now == NULL) return NULL;
			Object* old = now;
			now+=sizeof(Object);
			nSet++;
			return old;
		}

		bool operator<(int S)
		{
            return nSet<S;
		}

		bool operator>(int S)
		{
            return nSet>S;
		}

		Object* operator--(int dummy)
		{
			Object* old = this;
			this = back;
			return old;
		}

		Object& operator*()
		{
            return *now;
		}

		Object& operator->()
		{
            return *now;
		}

	} AccessItr;

	AccessItr			m_pItr;

	bool	(*m_swapExecPtr)(int,int);

public:

	typedef AccessItr	iterator;

	LTLArray(){ m_size=0; m_swapExecPtr=default_swap; }
	~LTLArray(){}
	
	void SetSizeSpan(int sp){ m_sizespan = sp; }

	bool		empty(){ return m_size==0 ? true : false; }
	iterator	begin(){ m_pItr.now = m_pItr.first; m_pItr.nSet = 0; return m_pItr; }
	iterator	end(){ return m_pItr; }
	
	//vflߍ
	void push_back(const Object& o)
	{
		m_size++;
		QueueStruct* q = new QueueStruct;
		q->ptObj = o;
		q->back = NULL;
		q->next = NULL;
		if( m_pItr.first == NULL ) { m_pItr.first = q; m_pItr.last = q; return; }
		q->back = m_pItr.last;
		q->back->next = q;
		m_pItr.last = q;
	}

	int		size()		 {	return m_size;	}
};
//-------------


// L[NX --------------------------------------------------------------------------------


template <class Object>
class LTLQueue {

	typedef struct _tagQueueStruct
	{
        Object	ptObj;
		_tagQueueStruct*	next;
		_tagQueueStruct*	back;

		Object& operator->()
		{
            return ptObj;
		}

		//L[}
		_tagQueueStruct* insert(_tagQueueStruct* q)
		{
			if( swapExecPtr(q->priority, priority) ) {
				q->back = back;
				q->next = this;
				if( back ) back->next = q;
				back = q;

				return q;
			}
			return next;
		}
	} QueueStruct;

	typedef struct _tagAccessItr
	{
		int					nSet;
		_tagQueueStruct*	first;
		_tagQueueStruct*	now;
		_tagQueueStruct*	last;

		_tagAccessItr()
		{
			first = now = last = NULL;
			nSet = 0;
		}

		_tagQueueStruct* operator++(int dummy)
		{
			if(now == NULL) return NULL;
			_tagQueueStruct* old = now;
			now = now->next;
			nSet++;
			return old;
		}

		bool operator<(int S)
		{
            return nSet<S;
		}

		bool operator>(int S)
		{
            return nSet>S;
		}

		_tagQueueStruct* operator--(int dummy)
		{
			_tagQueueStruct* old = this;
			this = back;
			return old;
		}

		_tagQueueStruct& operator*()
		{
            return *now;
		}

		Object& operator->()
		{
            return now->ptObj;
		}

	} AccessItr;

	int					m_size;
	AccessItr			m_pItr;

	bool	(*m_swapExecPtr)(int,int);

public:

	typedef AccessItr	iterator;

	LTLQueue(){ m_size=0; m_swapExecPtr=default_swap; }
	~LTLQueue(){}
	
	void SetSizeSpan(int sp){ m_sizespan = sp; }

	bool		empty(){ return m_size==0 ? true : false; }
	iterator	begin(){ m_pItr.now = m_pItr.first; m_pItr.nSet = 0; return m_pItr; }
	iterator	end(){ return m_pItr; }
	
	//vflߍ
	void push_back(const Object& o)
	{
		m_size++;
		QueueStruct* q = new QueueStruct;
		q->ptObj = o;
		q->back = NULL;
		q->next = NULL;
		if( m_pItr.first == NULL ) { m_pItr.first = q; m_pItr.last = q; return; }
		q->back = m_pItr.last;
		q->back->next = q;
		m_pItr.last = q;
	}

	void	erase(const iterator& i)
	{
		QueueStruct* q = i.now;
		//擙hւ
		if( q->back == NULL )
		{
			if( q->next )
			{
				q->next->back = NULL;
				m_pItr.first = q->next;
			}else{
				m_pItr.first = NULL;
			}
		}
		else
		{
			if( q->next )
			{
				q->next->back = q->back;
				q->back->next = q->next;
			}else
			{
				q->back->next = NULL;
				m_pItr.last = q->back;
			}
		}

		m_size--;
		delete q->ptObj;
		delete q;
	}

	int		size()		 {	return m_size;	}
};
//-------------



// yAExN^ --------------------------------------------------------------------------------


template <class Object, class PairKey>
class LTLPair {

	int						m_size;
	int						m_sizespan;
	std::vector<Object>		m_stlVector;
	std::vector<PairKey>	m_stlPair;

public:

	LTLPair(){ m_sizespan=256; m_size=0; m_stlVector.clear(); m_stlPair.clear(); }//Resize();  }
	LTLPair(int Size){ m_sizespan=Size; m_size=0; m_stlVector.clear(); Resize();  }
	~LTLPair(){}
	std::vector<Object>& GetObj(){ return m_stlVector; }
	
	void SetSizeSpan(int sp){ m_sizespan = sp; }
	void Resize()
	{
		m_stlVector.resize(m_size+m_sizespan);
	}
	
	void push_back(const Object& o, const PairKey& p)
	{
		m_size++;
		while( m_size > (signed)m_stlVector.size() ) Resize();
		m_stlVector.at(m_size-1) = o;
		m_stlPair.at(m_size-1) = p;
	}

	int		size()		 {	return m_size;	}
};
//-------------


// vCIeBtL[ ----------------------------------------------------------------------


bool default_swap(int a, int b);
extern bool default_swap(int a, int b);

template <class Object>
class LTLPriorityQueue {

	typedef struct _tagPQueueStruct
	{
		int		priority;
        Object	ptObj;

		_tagPQueueStruct*	next;
		_tagPQueueStruct*	back;
		bool	(*swapExecPtr)(int,int);
		_tagPQueueStruct(){ priority=0; next = NULL; back = NULL; swapExecPtr=default_swap; }
		~_tagPQueueStruct(){ /*SAFE_DELETE(ptObj);*/ }

		Object& operator->()
		{
            return ptObj;
		}

		//L[}
		_tagPQueueStruct* insert(_tagPQueueStruct* q)
		{
			if( swapExecPtr(q->priority, priority) ) {
				q->back = back;
				q->next = this;
				if( back ) back->next = q;
				back = q;

				return q;
			}
			return next;
		}

		//DxύXXbv
		_tagPQueueStruct* swap(_tagPQueueStruct* q)
		{
			if( back == NULL ) return NULL;

			_tagPQueueStruct* n = next;
			_tagPQueueStruct* b = back;
			_tagPQueueStruct* bb= back->back;

			//@ւKv̂́@1nA2bA2nA3bA3nA4b
			//   1          3       2    @@@4
			//1)O@nb@2)back n?b 3)this nb@4)ЂƂ
			if( swapExecPtr(priority, back->priority) ) {
				if(next) next->back = back;		//4bւ
				next = back;					//3nւ
				back = back->back;				//3bւ
				b->next = n;					//2nւ
				b->back = this;					//2bւ
				if( bb ) bb->next = this;		//1nւ

				return this;
			}
			return NULL;
		}
	} PQueueStruct;

	typedef struct _tagAccessItr
	{
		int					nSet;
		_tagPQueueStruct*	first;
		_tagPQueueStruct*	now;
		_tagPQueueStruct*	last;

		_tagAccessItr()
		{
			first = now = last = NULL;
			nSet = 0;
		}

		_tagPQueueStruct* operator++(int dummy)
		{
			if(now == NULL) return NULL;
			_tagPQueueStruct* old = now;
			now = now->next;
			nSet++;
			return old;
		}

		_tagPQueueStruct* operator+(int x)
		{
			_tagPQueueStruct* ret = now
			if(ret == NULL) return NULL;
			while( x > 0 )
			{
				if(ret == NULL) return NULL;
				ret = ret->next;
				x--;
			}
			return ret;
		}

		bool operator<(int S)
		{
            return nSet<S;
		}

		bool operator>(int S)
		{
            return nSet>S;
		}

		_tagPQueueStruct* operator--(int dummy)
		{
			_tagPQueueStruct* old = this;
			this = back;
			return old;
		}

		_tagPQueueStruct& operator*()
		{
            return *now;
		}

		Object& operator->()
		{
            return now->ptObj;
		}

	} AccessItr;


	int					m_size;
	int					m_sizespan;
	AccessItr			m_pItr;

	bool	(*m_swapExecPtr)(int,int);


public:

	typedef AccessItr	iterator;

	LTLPriorityQueue(){ m_sizespan=256; m_size=0; m_swapExecPtr=default_swap; }
	LTLPriorityQueue(int Size){ m_sizespan=Size; m_size=0; }
	~LTLPriorityQueue(){ clear(); }
	
	void SetSizeSpan(int sp){ m_sizespan = sp; }

	iterator	begin(){ m_pItr.now = m_pItr.first; m_pItr.nSet = 0; return m_pItr; }
	iterator	end(){ return m_pItr; }
	
	//S
	void clear()
	{
		PQueueStruct* rq;
		PQueueStruct* q = m_pItr.first;
		while( q !=  NULL )
		{
            rq = q->next;
			delete q;
			q = rq;
		}
		m_pItr.first=NULL;
	}

	//rZp̊֐ݒ肷(O[o)
	void SetSwapExe(bool (pFunc)(int,int))
	{
		PQueueStruct* q = m_pItr.first;
		while( q != NULL )
		{
			q->swapExecPtr = pFunc;
			q = q->next;
		}
		m_swapExecPtr = pFunc;
	}

	//vCIeBĕёւ
	void Sort(PQueueStruct* o)
	{
		PQueueStruct* rq = m_pItr.first;
		PQueueStruct* q = m_pItr.first;
		while( true ){ 
			rq = q;
			q = q->insert(o);
			if(q==o)
			{
				if(!rq->next) m_pItr.last = rq;
				if(!o->back) m_pItr.first = o;
				break;
			}
			if(!q)
			{
             	m_pItr.last->next = o;
				o->back = m_pItr.last;
				m_pItr.last = o; 
				break;
			}
		}
	}

	//vflߍ
	void push_back(const Object& o, int p)
	{
		m_size++;
		PQueueStruct* q = new PQueueStruct;
		q->ptObj = o;
		q->priority = p;
		q->back = NULL;
		q->next = NULL;
		q->swapExecPtr = m_swapExecPtr;
		if( m_pItr.first == NULL ) { m_pItr.first = q; m_pItr.last = q; return; }
		Sort(q);
	}

	//
	void erase(const Object& o)
	{
		PQueueStruct* rq;
		PQueueStruct* q = m_pItr.first;
		while( q !=  NULL )
		{
			if( q->ptObj == o)
			{
				if( q->back == NULL )  m_pItr.first = q->next;
				if( q->next == NULL )  m_pItr.last = q->back;
				rq = q->next;
				if(q->back) q->back->next = rq;
				if(q->next) q->next->back = q->back;
				delete q;
				break;
			}
			q = q->next;
		}
		m_size--;
//		if( m_size == 0 ) m_pItr.first = NULL;
	}

	//Dx
	void cngLayer(const Object& o, int p)
	{
		iterator q = begin();
		while( q<size() ){ if(q->ptObj==o) break; q++; }
	}

	int		size()		 {	return m_size;	}
};
//-------------


}