package jp.sourceforge.lepidolite.dao;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

/**
 * ݒIuWFNgB
 *
 */
public class DaoSettings {
	
	/**
	 * ݒt@C[hς݂ł邩B
	 */
	private static boolean loaded = false;
	
	/**
	 * ݒt@CB
	 */
	private static final String PROPERTY_FILENAME = "/lepidolite.properties";
	
	/**
	 * DAOgUNVNXB
	 */
	public static String DAO_TRANSACTION_FACTORY = "<undefined>";
	
	/**
	 * f[^\[XgۂɎgp郊\[XB
	 */
	public static String DATASOURCE_NAME = "<undefined>";
	
	/**
	 * JDBCڑۂɎgphCoNXB
	 */
	public static String JDBC_DRIVER = "<undefined>";
	
	/**
	 * JDBCڑۂɎgpURLB
	 */
	public static String JDBC_URL= "<undefined>";
	
	/**
	 * JDBCڑۂɎgp郆[UB
	 */
	public static String JDBC_USERNAME = "<undefined>";
	
	/**
	 * JDBCڑۂɎgppX[hB
	 */
	public static String JDBC_PASSWORD = "<undefined>";
	
	
	/**
	 * ݒt@CǂݍށB
	 * 
	 * @throws IOException ݒt@C̓ǂݍ݂ȂǂɎsꍇB
	 * @throws FileNotFoundException ݒt@CȂꍇB
	 */
	public static void load() throws IOException {
		load(false);
	}
	
	
	/**
	 * ݒt@CǂݍށB
	 * 
	 * @param force ݒt@CIɍēǂݍ݂B
	 * @throws IOException ݒt@C̓ǂݍ݂ȂǂɎsꍇB
	 * @throws FileNotFoundException ݒt@CȂꍇB
	 */
	public static void load(boolean force) throws IOException {
		if (loaded && !force) {
			return;
		}
		
		InputStream in = DaoSettings.class.getResourceAsStream(PROPERTY_FILENAME);
		if (in == null) {
			throw new FileNotFoundException("vpeBt@C '" + PROPERTY_FILENAME + "'܂B");
		}
		
		Properties prop = new Properties();
		prop.load(in);
		
		load(prop, force);
		
		loaded = true;
	}
	
	
	/**
	 * ݒǂݍށB
	 * 
	 * @param prop ݒB
	 * @param force ݒIɍēǂݍ݂B
	 * @throws IOException ݒt@C̓ǂݍ݂ȂǂɎsꍇB
	 * @throws FileNotFoundException ݒt@CȂꍇB
	 */
	public static void load(Properties prop, boolean force) throws IOException {
		if (loaded && !force) {
			return;
		}
		
		DAO_TRANSACTION_FACTORY = prop.getProperty("dao.transaction.factory");
		DATASOURCE_NAME = prop.getProperty("dao.datasource");
		JDBC_DRIVER = prop.getProperty("dao.jdbc.driver");
		JDBC_URL = prop.getProperty("dao.jdbc.url");
		JDBC_USERNAME = prop.getProperty("dao.jdbc.username");
		JDBC_PASSWORD = prop.getProperty("dao.jdbc.password");
		
		loaded = true;
	}
	
	
	/**
	 * RXgN^B
	 */
	private DaoSettings() {
	}
}
