package jp.sourceforge.lepidolite.dao;

import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import junit.framework.TestCase;

public class DaoTransactionFactoryTest extends TestCase {
	
	/**
	 * ڑł鎖mFB
	 */
	public void testConnect() {
		DaoTransaction trans = null;
		try {
			trans = DaoTransactionFactory.getTransaction("test");
			Connection conn = trans.getConnection();
			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery("select 1");
			if (rs.next()) {
				assertEquals("lmF", rs.getInt(1), 1);
			} else {
				fail("a");
			}
		} catch (DaoException de) {
			de.printStackTrace();
			fail();
		} catch (SQLException sqle) {
			sqle.printStackTrace();
			fail();
		} finally {
			trans.close();
		}
	}
	
	/**
	 * ConnectionvLVIuWFNgł鎖mFB
	 */
	public void testConnectionProxy() {
		DaoTransaction trans = null;
		try {
			trans = DaoTransactionFactory.getTransaction("test");
			Connection conn = trans.getConnection();
			assertTrue("ConnectionvLVł", Proxy.isProxyClass(conn.getClass()));
		} catch (DaoException de) {
			fail(de.getMessage());
		} finally {
			trans.close();
		}
	}
	
	/**
	 * Statement, ResultSetoRŎ擾ConnectionvLVł鎖mFB
	 */
	public void testProxyStatement() {
		DaoTransaction trans = null;
		try {
			trans = DaoTransactionFactory.getTransaction("test");
			Connection conn = trans.getConnection();
			
			Statement stmt = conn.createStatement();
			// 
			assertTrue(conn == stmt.getConnection());
			assertEquals(conn, stmt.getConnection());
			// StatementvLVł
			assertTrue(Proxy.isProxyClass(stmt.getClass()));
			// Statement擾ConnectionvLVł
			assertTrue(Proxy.isProxyClass(stmt.getConnection().getClass()));
			
			ResultSet rs = stmt.executeQuery("select 1");
			assertTrue(stmt == rs.getStatement());
			assertEquals(conn, stmt.getConnection());
			assertTrue(Proxy.isProxyClass(rs.getClass()));
			assertTrue(Proxy.isProxyClass(rs.getStatement().getClass()));
			
		} catch (DaoException de) {
			fail(de.getMessage());
		} catch (SQLException sqle) {
			fail(sqle.getMessage());
		} finally {
			trans.close();
		}
	}
}
