/*
 * Decompiled with CFR 0.152.
 */
package jp.que.ti.yhj.utils.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import jp.que.ti.yhj.utils.file.FileFilter;
import jp.que.ti.yhj.utils.file.FilteredFile;
import jp.que.ti.yhj.utils.file.FilteredLocalFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtils {
    private static final Pattern YEN_PATTERN = Pattern.compile("\\\\");
    public static final FileFilter NEED_ALL_FILTER = new FileFilter(){

        public boolean isNeed(FilteredFile file) {
            return true;
        }
    };
    private static final List<File> NULL_LIST = Collections.unmodifiableList(new ArrayList(0));

    private FileUtils() {
    }

    public static String relativePath(File baseDir, File file) {
        if (file == null) {
            throw new IllegalArgumentException("\u5f15\u6570 file \u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (baseDir == null) {
            throw new IllegalArgumentException("\u5f15\u6570 baseDir \u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        int len = baseDir.getAbsolutePath().length();
        String longPath = file.getAbsolutePath();
        String shortPath = longPath.substring(len);
        if (shortPath.indexOf("\\") >= 0) {
            shortPath = YEN_PATTERN.matcher(shortPath).replaceAll("/");
        }
        if (shortPath.indexOf("/") == 0) {
            shortPath = shortPath.substring(1);
        }
        return shortPath;
    }

    public static FileOutputStream createFileOutputStream(File file) {
        File parentFile = file.getParentFile();
        if (parentFile != null && !parentFile.exists()) {
            parentFile.mkdirs();
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("\u51fa\u529b\u30d5\u30a1\u30a4\u30eb\u3092\u958b\u3051\u307e\u305b\u3093\u3067\u3057\u305f:" + file.getAbsolutePath(), e);
        }
        return fos;
    }

    public static List<File> fileListWithDir(File fromFileOrDir) {
        return FileUtils.fileListWithDir(fromFileOrDir, NEED_ALL_FILTER);
    }

    public static List<File> fileListWithDir(File fromFileOrDir, FileFilter filter) {
        return FileUtils.fileList(fromFileOrDir, true, filter);
    }

    public static List<File> fileListWithNoDir(File fromFileOrDir) {
        return FileUtils.fileListWithNoDir(fromFileOrDir, NEED_ALL_FILTER);
    }

    public static List<File> fileListWithNoDir(File fromFileOrDir, FileFilter filter) {
        return FileUtils.fileList(fromFileOrDir, false, filter);
    }

    private static List<File> fileList(File fromFileOrDir, boolean withDir, FileFilter filter) {
        LinkedList<File> rtn = new LinkedList<File>();
        FilteredLocalFile ffile = new FilteredLocalFile(fromFileOrDir);
        if (!filter.isNeed(ffile)) {
            return NULL_LIST;
        }
        if (fromFileOrDir.isFile()) {
            rtn.add(fromFileOrDir);
        } else {
            File[] childs;
            if (withDir) {
                rtn.add(fromFileOrDir);
            }
            if ((childs = fromFileOrDir.listFiles()) != null) {
                for (int idx = 0; idx < childs.length; ++idx) {
                    File child = childs[idx];
                    List<File> grandchilds = FileUtils.fileList(child, withDir, filter);
                    rtn.addAll(grandchilds);
                }
            }
        }
        return rtn;
    }
}

