/*
 * Decompiled with CFR 0.152.
 */
package jp.que.ti.yhj.less.than.more;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import jp.que.ti.yhj.less.than.more.BackwardByteReader;
import jp.que.ti.yhj.less.than.more.ByteReader;
import jp.que.ti.yhj.less.than.more.ForwardByteReader;
import jp.que.ti.yhj.less.than.more.command.IllegalPositionException;

public class TextViewer {
    public static final int DEFAULT_READING_LENGTH = 3840;
    public static final String UTF_8 = "UTF-8";
    public static final String UTF_16LE = "UTF-16LE";
    public static final String UTF_16BE = "UTF-16BE";
    public static final String UTF_16 = "UTF-16";
    public static final String ISO_8859_1 = "ISO-8859-1";
    public static final String US_ASCII = "US-ASCII";
    public static final String SHIFT_JIS = "SJIS";
    public static final String EUC_JP = "EUC-JP";
    private long position;
    private long lastReadLength;
    private int readingLength = 3840;
    private File file;
    private String encoding = Charset.defaultCharset().name();
    private String lastViewCache = "";
    private byte[] _byteTemp4view = new byte[1024];
    private byte[] _byteTemp4viewToCrLf = new byte[1024];

    private byte[] extendBytesIfTooSmall(byte[] bytes, int newLength) {
        byte[] newTemp = null;
        if (bytes.length > newLength) {
            return bytes;
        }
        newTemp = new byte[newLength * 2];
        System.arraycopy(bytes, 0, newTemp, 0, bytes.length);
        return newTemp;
    }

    public final String getEncoding() {
        return this.encoding;
    }

    public final long getEndPosition() {
        return this.getPosition() + this.getLastReadLength();
    }

    public final File getFile() {
        return this.file;
    }

    public final long getLastReadLength() {
        return this.lastReadLength;
    }

    public final String getLastViewCache() {
        return this.lastViewCache;
    }

    public final long getPosition() {
        return this.position;
    }

    public final int getReadingLength() {
        return this.readingLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readLineBackward(long endPosition) {
        BackwardByteReader reader = new BackwardByteReader(this.getFile());
        byte[] rtn = null;
        try {
            rtn = reader.readLine(endPosition);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                throw new RuntimeException("\u30d5\u30a1\u30a4\u30eb\u30af\u30ed\u30fc\u30ba\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
            }
        }
        return rtn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readLineForward(long startPosition) {
        ForwardByteReader reader = new ForwardByteReader(this.getFile());
        byte[] rtn = null;
        try {
            rtn = reader.readToCrLf(startPosition);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                throw new RuntimeException("\u30d5\u30a1\u30a4\u30eb\u30af\u30ed\u30fc\u30ba\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
            }
        }
        return rtn;
    }

    private byte[] readToCrLf(long position, ByteReader reader) {
        reader.setPosition(position);
        int dataIdx = 0;
        int lastCRLFPos = -1;
        boolean notEnd = true;
        while (notEnd) {
            byte tempByte;
            int tmp = 0;
            tmp = reader.read();
            if (tmp < 0) {
                notEnd = false;
                continue;
            }
            this._byteTemp4viewToCrLf = this.extendBytesIfTooSmall(this._byteTemp4viewToCrLf, dataIdx);
            this._byteTemp4viewToCrLf[dataIdx] = tempByte = (byte)tmp;
            if (reader.isForward()) {
                if (tempByte == 10) {
                    lastCRLFPos = dataIdx;
                } else if (dataIdx - 1 >= 0 && this._byteTemp4viewToCrLf[dataIdx - 1] == 13) {
                    lastCRLFPos = dataIdx - 1;
                }
            } else if (tempByte == 13) {
                lastCRLFPos = dataIdx;
            } else if (dataIdx - 1 >= 0 && this._byteTemp4viewToCrLf[dataIdx - 1] == 10) {
                lastCRLFPos = dataIdx - 1;
            }
            if (lastCRLFPos >= 0) {
                notEnd = false;
            }
            ++dataIdx;
        }
        int copyLength = 0;
        copyLength = lastCRLFPos >= 0 ? lastCRLFPos + 1 : dataIdx;
        byte[] tmpBytes = new byte[copyLength];
        System.arraycopy(this._byteTemp4viewToCrLf, 0, tmpBytes, 0, copyLength);
        return tmpBytes;
    }

    public final void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public final void setFile(File file) {
        this.file = file;
    }

    final void setLastReadLength(long lastReadLength) {
        this.lastReadLength = lastReadLength;
    }

    private final void setLastViewCache(String lastViewCache) {
        this.lastViewCache = lastViewCache;
    }

    public final void setPosition(long position) {
        this.position = position;
    }

    public final void setReadingLength(int readingLength) {
        this.readingLength = readingLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String view() {
        ByteReader reader = null;
        byte[] record = null;
        int dataLen = 0;
        try {
            reader = new ForwardByteReader(this.getFile());
            boolean notEnd = true;
            record = this.readToCrLf(this.getPosition(), reader);
            int tmpLen = dataLen + record.length;
            if (tmpLen > this.getReadingLength()) {
                notEnd = false;
            }
            this._byteTemp4view = this.extendBytesIfTooSmall(this._byteTemp4view, tmpLen);
            System.arraycopy(record, 0, this._byteTemp4view, dataLen, record.length);
            long fileLastPos = this.getFile().length() - 1L;
            if (fileLastPos < this.getPosition() + (long)(dataLen += record.length)) {
                notEnd = false;
            }
            while (notEnd) {
                record = this.readToCrLf(this.getPosition() + (long)dataLen, reader);
                tmpLen = dataLen + record.length;
                if (tmpLen <= this.getReadingLength()) {
                    this._byteTemp4view = this.extendBytesIfTooSmall(this._byteTemp4view, tmpLen);
                    System.arraycopy(record, 0, this._byteTemp4view, dataLen, record.length);
                    if (fileLastPos >= this.getPosition() + (long)(dataLen += record.length)) continue;
                    notEnd = false;
                    continue;
                }
                notEnd = false;
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                throw new RuntimeException("\u30d5\u30a1\u30a4\u30eb\u30af\u30ed\u30fc\u30ba\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
            }
        }
        byte[] tmpBytes = new byte[dataLen];
        System.arraycopy(this._byteTemp4view, 0, tmpBytes, 0, dataLen);
        try {
            this.setLastViewCache(new String(tmpBytes, this.getEncoding()));
            this.setLastReadLength(tmpBytes.length);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return this.getLastViewCache();
    }

    public String viewNextPage() {
        if (this.getFile() == null) {
            String msg = "file is null";
            throw new NullPointerException("file is null");
        }
        long position = this.getEndPosition();
        if (position >= this.getFile().length()) {
            String msg = "\u30d5\u30a1\u30a4\u30eb\u306e\u7d42\u7aef\u306b\u9054\u3057\u3066\u3044\u307e\u3059\u3002position=" + position + " : fileLength=" + this.getFile().length() + " file=" + this.getFile().getAbsolutePath();
            throw new IllegalPositionException(msg);
        }
        this.setPosition(position);
        this.view();
        return this.getLastViewCache();
    }
}

