/*
 * Decompiled with CFR 0.152.
 */
package jp.que.ti.yhj.less.than.more;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.que.ti.yhj.less.than.more.ByteReaderBase;
import jp.que.ti.yhj.less.than.more.FileEdgeException;
import jp.que.ti.yhj.less.than.more.command.IllegalPositionException;

public class BackwardByteReader
extends ByteReaderBase {
    private final Logger log = Logger.getLogger(this.getClass().getName());
    private static final byte[] ZERO_BYTE_ARRAY = new byte[0];
    private File file;
    private FileChannel fileChannel;
    private long position = 0L;
    private byte[] bufferedByts = ZERO_BYTE_ARRAY;
    private int bufferPosition = -1;
    private int bufferAllocateSize = 1024;

    public BackwardByteReader(File file) {
        if (file == null) {
            throw new RuntimeException("file is null. \u30d5\u30a1\u30a4\u30eb\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        this.setFile(file);
        if (this.getFile().isDirectory()) {
            throw new RuntimeException("file is directory. \u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306f\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093");
        }
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(this.getFile(), "r");
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002getFile()=" + this.getFile().getAbsolutePath(), e);
        }
        this.setFileChannel(raf.getChannel());
        this.setPosition(this.getFile().length() - 1L);
        this.setBufferPosition(-1);
    }

    @Override
    public void close() throws IOException {
        if (this.getFileChannel().isOpen()) {
            this.getFileChannel().close();
        }
    }

    private final int getBufferAllocateSize() {
        return this.bufferAllocateSize;
    }

    private final byte[] getBufferedByts() {
        return this.bufferedByts;
    }

    private final int getBufferPosition() {
        return this.bufferPosition;
    }

    @Override
    public final File getFile() {
        return this.file;
    }

    private final FileChannel getFileChannel() {
        return this.fileChannel;
    }

    @Override
    public final long getPosition() {
        return this.position;
    }

    @Override
    public final boolean isForward() {
        return false;
    }

    @Override
    public int read() {
        if (this.getPosition() < 0L) {
            return -1;
        }
        if (this.getBufferPosition() < 0) {
            this.setBufferedByts(this.readToBuffer(this.getPosition()));
            this.setBufferPosition(this.getBufferedByts().length - 1);
        }
        byte rtn = this.getBufferedByts()[this.getBufferPosition()];
        this.setBufferPosition(this.getBufferPosition() - 1);
        this.setPositionOnly(this.getPosition() - 1L);
        int rtnInt = rtn & 0xFF;
        return rtnInt;
    }

    private byte[] readToBuffer(long endPosition) {
        int readLen;
        if (endPosition < 0L) {
            throw new FileEdgeException("\u30d5\u30a1\u30a4\u30eb\u306e\u5148\u7aef\u306b\u9054\u3057\u3066\u3044\u307e\u3059\u3002\u5f15\u6570 endPosition=" + endPosition);
        }
        long startPos = endPosition - (long)this.getBufferAllocateSize() + 1L;
        if (startPos < 0L) {
            startPos = 0L;
        }
        int maxReadLen = (int)(endPosition - startPos + 1L);
        ByteBuffer buf = ByteBuffer.allocate(maxReadLen);
        buf.clear();
        try {
            this.getFileChannel().position(startPos);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        try {
            readLen = this.getFileChannel().read(buf);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        buf.position(0);
        byte[] nowBytes = new byte[readLen];
        buf.get(nowBytes);
        if (this.log.isLoggable(Level.FINEST)) {
            String msg = "startPos=" + startPos + ":maxReadLen=" + maxReadLen + ":endPos=" + endPosition + ":readLen=" + readLen;
            this.log.finest(msg);
            this.log.finest("readToBuffer=" + new String(nowBytes));
        }
        return nowBytes;
    }

    public final void setBufferAllocateSize(int bufferAllocateSize) {
        this.bufferAllocateSize = bufferAllocateSize;
    }

    private final void setBufferedByts(byte[] bufferdByts) {
        this.bufferedByts = bufferdByts;
    }

    private final void setBufferPosition(int bufferdPosition) {
        this.bufferPosition = bufferdPosition;
    }

    private final void setFile(File file) {
        this.file = file;
    }

    private final void setFileChannel(FileChannel fileChannel) {
        this.fileChannel = fileChannel;
    }

    @Override
    public final void setPosition(long position) {
        if (this.getFile().length() <= position) {
            String msg = "\u30d5\u30a1\u30a4\u30eb\u306e\u7d42\u4e86\u30dd\u30b8\u30b7\u30e7\u30f3\u3092\u8d8a\u3048\u3066\u3044\u307e\u3059\u3002position=" + position + ": \u30d5\u30a1\u30a4\u30eb\u306e\u30dd\u30b8\u30b7\u30e7\u30f3\u306f0\u304b\u3089\u59cb\u307e\u308a\u30d5\u30a1\u30a4\u30eb\u30b5\u30a4\u30ba (" + this.getFile().length() + ") \u307e\u3067\u3067\u3059\u3002";
            throw new IllegalPositionException(msg);
        }
        long gap = position - this.getPosition();
        long newBufPos = (long)this.getBufferPosition() + gap;
        if (newBufPos < (long)this.getBufferAllocateSize() && newBufPos >= 0L) {
            this.setBufferPosition((int)newBufPos);
        } else {
            this.setBufferPosition(-1);
        }
        this.setPositionOnly(position);
    }

    private final void setPositionOnly(long position) {
        this.position = position;
    }

    @Override
    public byte[] readLine(long endPosition) {
        byte[] rtn1 = null;
        byte[] rtn2 = BYTES_NODATA;
        byte[] rtnCrLf = null;
        byte[] rtnRecord = null;
        int rtnCrlfLength = 0;
        int rtnRecordLength = 0;
        rtn1 = this.readToCrLf(endPosition);
        if (this.isCrLfOnly(rtn1)) {
            rtnCrLf = rtn1;
            rtn2 = this.readToCrLf(endPosition - (long)rtn1.length);
            rtnRecord = rtn2;
        } else {
            rtnCrLf = BYTES_NODATA;
            rtnRecord = rtn1;
        }
        rtnCrlfLength = rtnCrLf.length;
        rtnRecordLength = rtnRecord.length;
        if (rtnRecordLength > 0 && rtnRecord[rtnRecordLength - 1] == 13) {
            --rtnRecordLength;
        }
        if (rtnRecordLength > 0 && rtnRecord[rtnRecordLength - 1] == 10) {
            --rtnRecordLength;
        }
        if (rtnRecord.length != rtnRecordLength) {
            byte[] tmpBytes = new byte[rtnRecordLength];
            System.arraycopy(rtnRecord, 0, tmpBytes, 0, rtnRecordLength);
            rtnRecord = tmpBytes;
        }
        int rtnLength = rtnCrlfLength + rtnRecordLength;
        byte[] rtn = new byte[rtnLength];
        if (rtnCrlfLength != 0) {
            System.arraycopy(rtnCrLf, 0, rtn, 0, rtnCrlfLength);
        }
        if (rtnRecordLength != 0) {
            System.arraycopy(rtnRecord, 0, rtn, rtnCrlfLength, rtnRecordLength);
        }
        if (this.log.isLoggable(Level.FINEST)) {
            String msg = null;
            msg = "\n:rtn1=" + new String(rtn1) + "\n:rtn2=" + new String(rtn2) + "\n:rtnCrLf=" + new String(rtnCrLf) + "\n:rtnRecord=" + new String(rtnRecord) + "\n:end";
            this.log.finest(msg);
        }
        return this.reverse(rtn);
    }

    public byte[] reverse(byte[] bt) {
        int length = bt.length;
        byte[] rtn = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pos = length - i - 1;
            rtn[pos] = bt[i];
        }
        return rtn;
    }

    private boolean isCrLfOnly(byte[] rtnBytes) {
        if (rtnBytes.length == 1 && (rtnBytes[0] == 10 || rtnBytes[0] == 13)) {
            return true;
        }
        return rtnBytes.length == 2 && rtnBytes[0] == 10 && rtnBytes[1] == 13;
    }
}

