/*
 * Decompiled with CFR 0.152.
 */
package jp.que.ti.yhj.less.than.more.command;

import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.que.ti.yhj.less.than.more.BackwardByteReader;
import jp.que.ti.yhj.less.than.more.TextViewer;
import jp.que.ti.yhj.less.than.more.command.IllegalPositionException;
import jp.que.ti.yhj.less.than.more.command.SearchBaseCMD;

public class SearchBackwardCMD
extends SearchBaseCMD {
    public SearchBackwardCMD() {
    }

    public SearchBackwardCMD(TextViewer textViewer, String searchWord) {
        super(textViewer, searchWord);
    }

    @Override
    public void execute() {
        long fLength;
        long readPos = this.getTextViewer().getPosition();
        if (readPos >= (fLength = this.getTextViewer().getFile().length())) {
            readPos = fLength - 1L;
            this.getTextViewer().setPosition(readPos);
        }
        BackwardByteReader reader = new BackwardByteReader(this.getTextViewer().getFile());
        reader.setBufferAllocateSize(this.getTextViewer().getReadingLength() + 128);
        byte[] record = null;
        String recordString = null;
        Pattern pattern = Pattern.compile(this.getSearchWord());
        boolean notEnd = true;
        while (notEnd) {
            Matcher mtch;
            if (readPos <= 0L) {
                String errMsg = "\u5148\u982d\u307e\u3067\u691c\u7d22\u3057\u307e\u3057\u305f\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f";
                this.getTextViewer().setPosition(0L);
                throw new IllegalPositionException("\u5148\u982d\u307e\u3067\u691c\u7d22\u3057\u307e\u3057\u305f\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f");
            }
            record = reader.readLine(readPos);
            try {
                recordString = new String(record, this.getTextViewer().getEncoding());
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            if (readPos < 0L) {
                readPos = 0L;
            }
            boolean bl = notEnd = !(mtch = pattern.matcher(recordString)).find();
            if (notEnd) {
                if (this.log.isLoggable(infoLogLevel)) {
                    String msg = "Now searching at position=" + readPos + " searchWord=" + this.getSearchWord();
                    this.log.log(infoLogLevel, msg);
                }
                readPos -= (long)record.length;
                continue;
            }
            int pos = mtch.start();
            String frontStr = recordString.substring(0, pos);
            byte[] frontBytes = null;
            try {
                frontBytes = frontStr.getBytes(this.getTextViewer().getEncoding());
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            this.getTextViewer().setPosition(readPos - (long)record.length + 1L + (long)frontBytes.length);
        }
        this.getTextViewer().view();
    }
}

