/*
 * Decompiled with CFR 0.152.
 */
package jp.que.ti.yhj.less.than.more.command;

import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.que.ti.yhj.less.than.more.TextViewer;
import jp.que.ti.yhj.less.than.more.command.IllegalPositionException;
import jp.que.ti.yhj.less.than.more.command.SearchBaseCMD;

public class SearchForwardCMD
extends SearchBaseCMD {
    public SearchForwardCMD() {
    }

    public SearchForwardCMD(TextViewer textViewer, String searchWord) {
        super(textViewer, searchWord);
    }

    @Override
    public void execute() {
        if (this.getTextViewer().getPosition() >= this.getTextViewer().getFile().length() - 1L) {
            return;
        }
        boolean notEnd = true;
        Pattern pattern = Pattern.compile(this.getSearchWord());
        this.getTextViewer().setPosition(this.getTextViewer().getPosition() + 1L);
        String str = this.getTextViewer().view();
        while (notEnd) {
            Matcher mtch = pattern.matcher(str);
            boolean bl = notEnd = !mtch.find();
            if (notEnd) {
                if (this.log.isLoggable(infoLogLevel)) {
                    String infoMsg = "Now searching at position=" + this.getTextViewer().getPosition() + " searchWord=" + this.getSearchWord();
                    this.log.log(infoLogLevel, infoMsg);
                }
                try {
                    str = this.getTextViewer().viewNextPage();
                    continue;
                }
                catch (IllegalPositionException e) {
                    notEnd = false;
                    this.getTextViewer().setPosition(this.getTextViewer().getFile().length());
                    str = this.getTextViewer().view();
                    throw e;
                }
            }
            int pos = mtch.start();
            String frontStr = str.substring(0, pos);
            byte[] frontBytes = null;
            try {
                frontBytes = frontStr.getBytes(this.getTextViewer().getEncoding());
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            this.getTextViewer().setPosition(this.getTextViewer().getPosition() + (long)frontBytes.length);
            str = this.getTextViewer().view();
        }
    }
}

