/*
 * Decompiled with CFR 0.152.
 */
package jp.que.ti.yhj.less.than.more;

import java.io.File;
import java.util.logging.Logger;
import jp.que.ti.yhj.less.than.more.TextViewer;
import jp.que.ti.yhj.less.than.more.command.IllegalPositionException;
import jp.que.ti.yhj.less.than.more.command.NextPagePositionCMD;
import jp.que.ti.yhj.less.than.more.command.PositionCMD;
import jp.que.ti.yhj.less.than.more.command.PriviousPagePositionCMD;
import jp.que.ti.yhj.less.than.more.command.SearchBackwardCMD;
import jp.que.ti.yhj.less.than.more.command.SearchBaseCMD;
import jp.que.ti.yhj.less.than.more.command.SearchForwardCMD;
import jp.que.ti.yhj.less.than.more.command.ViewCMD;

public abstract class LessThanMoreController {
    public static final String APLICATION_NAME = "lessThanMore";
    private Logger log = Logger.getLogger(this.getClass().getName());
    private NextPagePositionCMD nextPageCMD;
    private PriviousPagePositionCMD previousPageCMD;
    private PositionCMD position;
    private ViewCMD viewCommand;
    private String searchWord;
    private TextViewer viewer;

    public LessThanMoreController() {
        this.setViewer(new TextViewer());
        this.setNextPageCMD((NextPagePositionCMD)new NextPagePositionCMD().setTextViewer(this.getViewer()));
        this.setPreviousPageCMD((PriviousPagePositionCMD)new PriviousPagePositionCMD().setTextViewer(this.getViewer()));
        this.setPosition((PositionCMD)new PositionCMD(0L).setTextViewer(this.getViewer()));
        this.setViewCommand((ViewCMD)new ViewCMD().setTextViewer(this.getViewer()));
    }

    public final NextPagePositionCMD getNextPageCMD() {
        return this.nextPageCMD;
    }

    public final PositionCMD getPosition() {
        return this.position;
    }

    protected final PriviousPagePositionCMD getPreviousPageCMD() {
        return this.previousPageCMD;
    }

    public final String getSearchWord() {
        return this.searchWord;
    }

    public final ViewCMD getViewCommand() {
        return this.viewCommand;
    }

    public final TextViewer getViewer() {
        return this.viewer;
    }

    protected String searchBackward() {
        SearchBackwardCMD command = new SearchBackwardCMD(this.getViewer(), this.getSearchWord());
        return this.search(command);
    }

    protected String searchForward() {
        SearchForwardCMD command = new SearchForwardCMD(this.getViewer(), this.getSearchWord());
        return this.search(command);
    }

    protected final String search(SearchBaseCMD searchCommand) {
        searchCommand.execute();
        return searchCommand.getTextViewer().getLastViewCache();
    }

    public void setFile(File file) {
        this.getViewer().setFile(file);
    }

    private final void setNextPageCMD(NextPagePositionCMD nextPageCMD) {
        this.nextPageCMD = nextPageCMD;
    }

    public final void setPosition(PositionCMD posisin) {
        this.position = posisin;
    }

    private final void setPreviousPageCMD(PriviousPagePositionCMD previousPageCMD) {
        this.previousPageCMD = previousPageCMD;
    }

    public final void setSearchWord(String searchWord) {
        this.searchWord = searchWord;
    }

    public final void setViewCommand(ViewCMD viewCommand) {
        this.viewCommand = viewCommand;
    }

    public final void setViewer(TextViewer viewer) {
        this.viewer = viewer;
    }

    protected String viewNextPage() {
        this.getNextPageCMD().execute();
        return this.getViewer().getLastViewCache();
    }

    protected String viewPreviousPage() {
        try {
            this.getPreviousPageCMD().execute();
        }
        catch (IllegalPositionException e) {
            this.log.info(e.getMessage());
            throw e;
        }
        return this.getViewer().getLastViewCache();
    }
}

