/*
 * Decompiled with CFR 0.152.
 */
package jp.que.ti.yhj.utils;

import java.util.LinkedList;
import java.util.List;
import jp.que.ti.yhj.utils.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionUtils {
    static final String LINE_SEPARATOR = StringUtils.LINE_SEPARATOR;

    private ExceptionUtils() {
    }

    public static String stackTraceString(Throwable th) {
        StringBuilder sb = new StringBuilder();
        sb.append(th + LINE_SEPARATOR);
        sb = ExceptionUtils.stackTraceString2StringBuilder(th, sb);
        List<Throwable> causes = ExceptionUtils.causes(th);
        for (Throwable cause : causes) {
            sb.append("Caused by: " + cause + LINE_SEPARATOR);
            sb = ExceptionUtils.stackTraceString2StringBuilder(cause, sb);
        }
        return sb.toString();
    }

    private static List<Throwable> causes(Throwable th) {
        LinkedList<Throwable> rtn = new LinkedList<Throwable>();
        Throwable nowCause = null;
        for (nowCause = th.getCause(); nowCause != null; nowCause = nowCause.getCause()) {
            rtn.add(nowCause);
        }
        return rtn;
    }

    private static StringBuilder stackTraceString2StringBuilder(Throwable throwable, StringBuilder warehouseBuf) {
        if (throwable == null) {
            return warehouseBuf;
        }
        StackTraceElement[] trace = throwable.getStackTrace();
        for (int i = 0; i < trace.length; ++i) {
            warehouseBuf.append("\tat " + trace[i] + LINE_SEPARATOR);
        }
        return warehouseBuf;
    }
}

