/*
 * created  2008/06/16 
 * Copyright 2008 yhj All rights reserved.
 */
package jp.que.ti.yhj.less.than.more;

import java.io.File;
import java.util.logging.Logger;

import jp.que.ti.yhj.less.than.more.command.IllegalPositionException;
import jp.que.ti.yhj.less.than.more.command.NextPagePositionCMD;
import jp.que.ti.yhj.less.than.more.command.PositionCMD;
import jp.que.ti.yhj.less.than.more.command.PriviousPagePositionCMD;
import jp.que.ti.yhj.less.than.more.command.SearchBackwardCMD;
import jp.que.ti.yhj.less.than.more.command.SearchBaseCMD;
import jp.que.ti.yhj.less.than.more.command.SearchForwardCMD;
import jp.que.ti.yhj.less.than.more.command.ViewCMD;

/**
 * @author yhj
 * @author $Author$ (last modified)
 * @version $Revision$
 */
public abstract class LessThanMoreController {
	public static final String APLICATION_NAME = "lessThanMore";
	private Logger log = Logger.getLogger(getClass().getName());
	private NextPagePositionCMD nextPageCMD;
	private PriviousPagePositionCMD previousPageCMD;
	private PositionCMD position;
	private ViewCMD viewCommand;
	private String searchWord;

	private TextViewer viewer;

	public LessThanMoreController() {
		setViewer(new TextViewer());
		setNextPageCMD((NextPagePositionCMD) new NextPagePositionCMD()
				.setTextViewer(getViewer()));
		setPreviousPageCMD((PriviousPagePositionCMD) new PriviousPagePositionCMD()
				.setTextViewer(getViewer()));
		setPosition((PositionCMD) new PositionCMD(0).setTextViewer(getViewer()));
		setViewCommand((ViewCMD) new ViewCMD().setTextViewer(getViewer()));
	}

	public final NextPagePositionCMD getNextPageCMD() {
		return nextPageCMD;
	}

	public final PositionCMD getPosition() {
		return position;
	}

	protected final PriviousPagePositionCMD getPreviousPageCMD() {
		return previousPageCMD;
	}

	public final String getSearchWord() {
		return searchWord;
	}

	public final ViewCMD getViewCommand() {
		return viewCommand;
	}

	/**
	 * {@link TextViewer} を取得します。
	 * 
	 * @return {@link TextViewer}
	 */
	public final TextViewer getViewer() {
		return viewer;
	}

	/**
	 * 後方文字列検索します。
	 * 
	 * @return 検索結果として表示するテキストファイルの部分文字列
	 */
	protected String searchBackward() {
		final SearchBackwardCMD command = new SearchBackwardCMD(getViewer(),
				getSearchWord());
		return search(command);
	}

	/**
	 * 前方文字列検索します。
	 * 
	 * @return 検索結果として表示するテキストファイルの部分文字列
	 */
	protected String searchForward() {
		final SearchForwardCMD command = new SearchForwardCMD(getViewer(),
				getSearchWord());
		return search(command);
	}

	/**
	 * 文字列検索します。引数 searchCommand によって検索方法の詳細が決定します
	 * 
	 * @param searchCommand
	 *            検索に使用するコマンド
	 * @return 検索結果として表示するテキストファイルの部分文字列
	 */
	protected final String search(SearchBaseCMD searchCommand) {
		searchCommand.execute();
		return searchCommand.getTextViewer().getLastViewCache();
	}

	/**
	 * {@link #getViewer()} で取得した{@link TextViewer}オブジェクトに対して
	 * {@link TextViewer#setFile(File)}を呼び出します
	 */
	public void setFile(File file) {
		getViewer().setFile(file);
	}

	private final void setNextPageCMD(NextPagePositionCMD nextPageCMD) {
		this.nextPageCMD = nextPageCMD;
	}

	public final void setPosition(PositionCMD posisin) {
		this.position = posisin;
	}

	private final void setPreviousPageCMD(
			PriviousPagePositionCMD previousPageCMD) {
		this.previousPageCMD = previousPageCMD;
	}

	public final void setSearchWord(String searchWord) {
		this.searchWord = searchWord;
	}

	public final void setViewCommand(ViewCMD viewCommand) {
		this.viewCommand = viewCommand;
	}

	/**
	 * {@link TextViewer} を設定します
	 * 
	 * @param viewer
	 *            {@link TextViewer}
	 */
	public final void setViewer(TextViewer viewer) {
		this.viewer = viewer;
	}

	/**
	 * 次ページに読み込みアドレスを移動して、次ページの文字列を返却します
	 * 
	 * @return 次ページの文字列
	 */
	public String viewNextPage() {
		getNextPageCMD().execute();
		return getViewer().getLastViewCache();
	}

	/**
	 * 前ページに読み込みアドレスを移動して、前ページの文字列を返却します
	 * 
	 * @return 前ページの文字列
	 */
	public String viewPreviousPage() {
		try {
			getPreviousPageCMD().execute();
		} catch (IllegalPositionException e) {
			log.info(e.getMessage());
			throw e;
		}
		return getViewer().getLastViewCache();
	}

	/**
	 * 最終ページに読み込みアドレスを移動して、最終ページの文字列を返却します
	 * 
	 * @return 前ページの文字列
	 */
	public String viewLastPage() {
		final File fl = getViewer().getFile();
		if (fl == null) {
			throw new NullPointerException("読み込みファイルが設定されていません");
		}
		final long len = fl.length();
		getViewer().setPosition(len);
		try {
			getPreviousPageCMD().execute();
		} catch (IllegalPositionException e) {
			log.info(e.getMessage());
			throw e;
		}
		return getViewer().getLastViewCache();
	}

}
