/*
 * created  2009/05/07
 * Copyright 2008 yhj All rights reserved.
 */
package jp.que.ti.yhj.less.than.more.sw;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

import jp.que.ti.yhj.less.than.more.swview.AboutThisDialog;

/**
 * About This ダイアログを表示するためのアクションリスナー
 *
 * @author yhj
 * @author $Author$ (last modified)
 * @version $Revision$
 */
public class AboutThisActionListener extends LessThanMoreBaseActionListener {
	@Override
	public void actionPerformed(ActionEvent event) {
		final AboutThisDialog dialog = new AboutThisDialog(getController()
				.getFrame(), true);
		dialog.setVersionNoString(getController().getFrame()
				.getVersionNoString());
		int posX = getController().getFrame().getBounds().x;
		int posY = getController().getFrame().getBounds().y;
		if (posX < 0) {
			posX = 0;
		}
		if (posY < 0) {
			posY = 0;
		}
		dialog.setBounds(posX, posY, dialog.getSize().width,
				dialog.getSize().height);

		// Esc 押下したら閉じるようにする start
		@SuppressWarnings("serial")
		AbstractAction act = new AbstractAction() {
			public void actionPerformed(ActionEvent e) {
				dialog.dispose();
			}
		};
		InputMap imap = dialog.getRootPane().getInputMap(
				JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);
		final String actionMapKye = "close_aboutThisDialog";
		imap.put(KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), actionMapKye);
		dialog.getRootPane().getActionMap().put(actionMapKye, act);
		// Esc 押下したら閉じるようにする end

		dialog.setVisible(true);
	}
}
