/*
 * created  2009/05/24
 * Copyright 2008 yhj All rights reserved.
 */
package jp.que.ti.yhj.less.than.more.sw;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.logging.Level;

/**
 * @author yhj
 * @author $Author$ (last modified)
 * @version $Revision$
 */
public class LastPageActionListener extends LessThanMoreBaseActionListener {
	@Override
	public void actionPerformed(ActionEvent ev) {
		final File fl = getController().getViewer().getFile();
		if (fl == null) {
			return;
		}

		try {
			lastPage(getController());
		} catch (RuntimeException e) {
			log.log(Level.INFO, e.getMessage(), e);
			getController().setStatusMessage(e);
		}
	}

	public static void lastPage(LessThanMoreSwingFrameController controller) {
		final int rSize = controller.readingSize();
		controller.getViewer().setReadingLength(rSize);
		controller.getFrame().setReadingLengthString("" + rSize);
		controller.viewLastPage();
		controller.clearAndUpdate();
		controller.clearStatusMessage();
		controller.textAreaCaretPositionToBottom();
	}
}
