/*
 * created  2009/05/04
 * Copyright 2008 yhj All rights reserved.
 */
package jp.que.ti.yhj.less.than.more.sw;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

import jp.que.ti.yhj.less.than.more.swview.LessThanMoreDefaultFrame;
import jp.que.ti.yhj.utils.StringUtils;

/**
 * メニュー設定情報オブジェクト。このクラスが、{@link LessThanMoreDefaultFrame}
 * または、そのサブクラスのメニューに表示されうるメニューを管理します。
 *
 * @author yhj
 * @author $Author$ (last modified)
 * @version $Revision$
 * @param <T>
 */
public class MenuConfig {
	public static final String OPEN_FILE_KEY = "open";
	public static final String NEXT_PAGE_KEY = "next_page";
	public static final String PREVIOUS_PAGE_KEY = "previous_page";
	public static final String LAST_PAGE_KEY = "last_page";
	public static final String TOP_PAGE_KEY = "top_page";
	public static final String FORWARD_FOREVER = "forward_forever";
	public static final String CANCEL = "cancel";
	public static final String LINE_WRAP_KEY = "line_wrap";
	public static final String CLEAR_KEY = "clear";
	public static final String ABOUT_THIS_KEY = "about";
	public static final String USAGE_IN_WEB_KEY = "usage_web";

	private static final int INIT_CAPACITY = 5;

	boolean isLoop4ForwardForeverActionListener = false;

	/** トップレベルメニューの一覧 */
	private List<JMenu> topMenus = new ArrayList<JMenu>(INIT_CAPACITY);

	/** メニューアイテムの一覧Map */
	private Map<String, JMenuItem> menuItems = new HashMap<String, JMenuItem>();

	private LessThanMoreSwingFrameController controller;

	/** コンストラクタ */
	public MenuConfig(LessThanMoreSwingFrameController controller) {
		this.controller = controller;
		init();
	}

	private LessThanMoreBaseActionListener createActionListener(
			Class<? extends LessThanMoreBaseActionListener> lessThanMoreBaseActionListenerClazz) {
		LessThanMoreBaseActionListener actionListener = null;
		try {
			actionListener = lessThanMoreBaseActionListenerClazz.newInstance();
		} catch (InstantiationException e) {
			throw new RuntimeException(e.getMessage(), e);
		} catch (IllegalAccessException e) {
			throw new RuntimeException(e.getMessage(), e);
		}
		actionListener.setController(this.controller);
		return actionListener;
	}

	/**
	 * 簡易版ファクトリーメソッド。GOFのファクトリーメソッドパターンは少々面倒なので通常はこのメソッドを使用して、
	 * {@link LessThanMoreBaseActionListener}オブジェクトを生成する。
	 *
	 * @param lessThanMoreBaseActionListenerClazz
	 * @throws ClassCastException
	 *             引数 lessThanMoreBaseActionListenerClazz が
	 *             {@link LessThanMoreBaseActionListener}または、そのサブクラス名でない場合スローされる
	 *
	 */
	public LessThanMoreBaseActionListener createActionListener(
			String lessThanMoreBaseActionListenerClazz) {
		Class<?> cls = null;
		try {
			cls = Class.forName(lessThanMoreBaseActionListenerClazz);
		} catch (ClassNotFoundException e) {
			throw new RuntimeException(e.getMessage(), e);
		}
		Class<? extends LessThanMoreBaseActionListener> listenerClazz = cls
				.asSubclass(LessThanMoreBaseActionListener.class);
		return createActionListener(listenerClazz);
	}

	private JCheckBoxMenuItem createJCheckBoxMenuItem(String key, String name,
			LessThanMoreBaseActionListener listener, String keyStroke) {
		JCheckBoxMenuItem rtn = new JCheckBoxMenuItem(name, null);
		this.menuItems.put(key, rtn);
		if (listener == null) {
		} else {
			rtn.addActionListener(listener);
		}
		if (StringUtils.isEmpty(keyStroke)) {
		} else {
			rtn.setAccelerator(KeyStroke.getKeyStroke(keyStroke));
		}
		return rtn;

	}

	private JMenu createJMenu(String name) {
		JMenu rtn = new JMenu(name);
		return rtn;
	}

	private JMenuItem createJMenuItem(String key, String text,
			LessThanMoreBaseActionListener listener, String keyStroke) {
		JMenuItem rtn = new JMenuItem(text, null);
		this.menuItems.put(key, rtn);
		if (listener == null) {
		} else {
			rtn.addActionListener(listener);
		}
		if (StringUtils.isEmpty(keyStroke)) {
		} else {
			rtn.setAccelerator(KeyStroke.getKeyStroke(keyStroke));
		}
		return rtn;
	}

	/**
	 * メニューの一覧を取得します
	 *
	 * @return
	 */
	public Map<String, JMenuItem> getMenuItems() {
		return menuItems;
	}

	/**
	 * トップレベルメニューの一覧を返却します
	 *
	 * @return トップレベルメニューの一覧
	 */
	public List<JMenu> getTopMenus() {
		return topMenus;
	}

	/**
	 * このオブジェクトが管理しているすべての{@link JMenuItem} を有効または無効にします。
	 *
	 * @param isEnabled
	 *            項目を有効にする場合は true
	 */
	public void setEnabledAllMenus(boolean isEnabled) {
		for (JMenuItem menuItem : getMenuItems().values()) {
			menuItem.setEnabled(isEnabled);
		}
	}

	private void init() {
		topMenus.add(createJMenu("File"));
		topMenus.add(createJMenu("View"));
		topMenus.add(createJMenu("Help"));

		// 1番目のメニュー (File)
		topMenus.get(0).add(//
				createJMenuItem(OPEN_FILE_KEY, "open",
						createActionListener(OpenFileActionListener.class)//
						, "control O"));
		topMenus.get(0).add(//
				createJMenuItem(NEXT_PAGE_KEY, "next Page",
						createActionListener(NextPageActionListener.class)//
						, "control F"));
		topMenus.get(0).add(//
				createJMenuItem(PREVIOUS_PAGE_KEY, "previous Page",
						createActionListener(PreviousPageActionListener.class)//
						, "control B"));
		topMenus.get(0).add(//
				createJMenuItem(LAST_PAGE_KEY, "last Page",
						createActionListener(LastPageActionListener.class)//
						, "ctrl shift G"));
		topMenus.get(0).add(//
				createJMenuItem(TOP_PAGE_KEY, "top Page",
						createActionListener(TopPageActionListener.class)//
						, "ctrl G"));
		topMenus.get(0)
				.add(//
				createJMenuItem(
						FORWARD_FOREVER,
						"forward forever(like 'tail -f')",
						createActionListener(ForwardForeverActionListener.class)//
						, "ctrl shift F"));

		topMenus.get(0)
				.add(//
				createJMenuItem(
						CANCEL,
						"cancel (doing...)",
						createActionListener(CancelForwardForeverActionListener.class)//
						, "ctrl shift C"));

		// 2番目のメニュー (View)
		topMenus.get(1).add(//
				createJCheckBoxMenuItem(LINE_WRAP_KEY, "line wrap",
						createActionListener(LineWrapActionListener.class)//
						, null));
		topMenus.get(1).add(//
				createJMenuItem(CLEAR_KEY, "clear",
						createActionListener(ClearActionListener.class)//
						, null));

		// 3番目のメニュー (Help)
		topMenus.get(2).add(//
				createJMenuItem(ABOUT_THIS_KEY, "about lessThanMore",
						createActionListener(AboutThisActionListener.class)//
						, null));
		topMenus.get(2).add(//
				createJMenuItem(USAGE_IN_WEB_KEY, "usage (in WEB Site)",
						createActionListener(UsageInWebListener.class)//
						, "F1"));
	}
}
