/*
 * created  2008/08/07
 * Copyright 2008 yhj All rights reserved.
 */
package jp.que.ti.yhj.less.than.more;

import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * 順方向または逆方向にファイル読み込みを実現するための基本的な機能を実装した抽象クラスです
 *
 * @author yhj
 * @author $Author$ (last modified)
 * @version $Revision$
 */
public abstract class ByteReaderBase implements ByteReader {
	private final Logger log = Logger.getLogger(getClass().getName());

	private byte[] _byteTemp4viewToCrLf = new byte[1024];

	protected byte[] readToCrLf(long position) {
		setPosition(position);
		int dataIdx = 0;
		int lastCRLFPos = -1;
		boolean notEnd = true;
		while (notEnd) {
			int tmp = 0;
			tmp = read();

			if (log.isLoggable(Level.FINEST)) {
				log.finest(Integer.toHexString(tmp & 0x00ff) + "<--"
						+ log.getName());
				log.finest(new String(new byte[] { (byte) tmp }));
			}

			if (tmp < 0) {
				notEnd = false;
			} else {
				// _byteTemp4viewToCrLf サイズが足りなければ拡張
				_byteTemp4viewToCrLf = extendBytesIfTooSmall(
						_byteTemp4viewToCrLf, dataIdx);
				final byte tempByte = (byte) tmp;
				_byteTemp4viewToCrLf[dataIdx] = tempByte;
				if (isForward()) {
					if (tempByte == '\n') {// ラインフィード
						lastCRLFPos = dataIdx;
					} else if (dataIdx - 1 >= 0 //
							&& _byteTemp4viewToCrLf[dataIdx - 1] == '\r') {// キャリッジリターン
						lastCRLFPos = dataIdx - 1;
					}
				} else {
					if (tempByte == '\r') {// キャリッジリターン
						lastCRLFPos = dataIdx;
					} else if (dataIdx - 1 >= 0 //
							&& _byteTemp4viewToCrLf[dataIdx - 1] == '\n') {// ラインフィード
						lastCRLFPos = dataIdx - 1;
					}
				}
				if (lastCRLFPos < 0) {// 改行が1回も出現していない
					// 終了しない
				} else {
					notEnd = false; // 読み込み終了
				}
				dataIdx++;
				if (dataIdx >= maximumReadingSize()) {
					notEnd = false; // 読み込み終了
				}
			}
		}

		int copyLength = 0;
		if (lastCRLFPos >= 0) {
			copyLength = lastCRLFPos + 1;
		} else {
			copyLength = dataIdx;
		}

		byte[] tmpBytes = new byte[copyLength];
		System.arraycopy(_byteTemp4viewToCrLf, 0, tmpBytes, 0, copyLength);
		return tmpBytes;

	}

	private byte[] extendBytesIfTooSmall(byte[] bytes, int newLength) {
		byte[] newTemp = null;
		if (bytes.length > newLength) { // 格納可能なので問題なし
			return bytes;
		} else { // 格納スペースがないため拡張
			newTemp = new byte[newLength * 2];
			System.arraycopy(bytes, 0, newTemp, 0, bytes.length);
			return newTemp;
		}
	}

	final static private int MAX_SIZE = 1024 * 256;

	/** {@link OutOfMemoryError} を防止するための読み込み最大サイズ */
	@Override
	public int maximumReadingSize() {
		return MAX_SIZE;
	}
}
