/*
 * created  2008/08/11
 * Copyright 2008 yhj All rights reserved.
 */
package jp.que.ti.yhj.less.than.more.command;

import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import jp.que.ti.yhj.less.than.more.BackwardByteReader;
import jp.que.ti.yhj.less.than.more.TextViewer;

/**
 * 後方文字列検索する命令クラス
 *
 * @author yhj
 * @author $Author$ (last modified)
 * @version $Revision$
 */
public class SearchBackwardCMD extends SearchBaseCMD {
	/** コンストラクタ */
	public SearchBackwardCMD() {
		super();
	}

	/**
	 * コンストラクタ
	 *
	 * @param textViewer
	 *            {@link TextViewer} オブジェクト
	 * @param searchWord
	 *            検索文字列
	 */
	public SearchBackwardCMD(TextViewer textViewer, String searchWord) {
		super(textViewer, searchWord);
	}

	/**
	 * 後方文字列検索を実行し、検索した見つけた文字列を読み込み先頭位置にします。<br>
	 * 検索文字列を先頭に設定した文字列は{@link #getTextViewer()} で取得したオブジェクトに対して
	 * {@link TextViewer#getLastViewCache()} を発行して取得できます。
	 *
	 * @see jp.que.ti.yhj.less.than.more.command.CommandInterface#execute()
	 */
	@Override
	public void execute() {
		long readPos = getTextViewer().getPosition();
		final long fLength = getTextViewer().getFile().length();
		if (readPos >= fLength) {
			readPos = fLength - 1;
			getTextViewer().setPosition(readPos);
		}
		BackwardByteReader reader = new BackwardByteReader(getTextViewer()
				.getFile());
		reader.setBufferAllocateSize(getTextViewer().getReadingLength() + 128);

		byte[] record = null;
		String recordString = null;
		Pattern pattern = Pattern.compile(getSearchWord());
		boolean notEnd = true;
		while (notEnd) {
			if (readPos <= 0) {
				final String errMsg = "先頭まで検索しましたが見つかりませんでした";
				getTextViewer().setPosition(0);
				throw new IllegalPositionException(errMsg);
			}
			record = reader.readLine(readPos);
			try {
				recordString = new String(record, getTextViewer().getEncoding());
			} catch (UnsupportedEncodingException e) {
				throw new RuntimeException(e.getMessage(), e);
			}

			if (readPos < 0) {
				readPos = 0;
			}
			final Matcher mtch = pattern.matcher(recordString);
			notEnd = !(mtch.find());
			if (notEnd) {
				if (log.isLoggable(infoLogLevel)) {// ログ出力
					final String msg = "Now searching at position=" + readPos
							+ " searchWord=" + getSearchWord();
					log.log(infoLogLevel, msg);
				}

				readPos = readPos - record.length;
			} else {
				int pos = mtch.start();
				String frontStr = recordString.substring(0, pos);
				byte[] frontBytes = null;
				try {
					frontBytes = frontStr.getBytes(getTextViewer()
							.getEncoding());
				} catch (UnsupportedEncodingException e) {
					throw new RuntimeException(e);
				}
				getTextViewer().setPosition(//
						readPos - record.length + 1 //
								+ frontBytes.length);
			}
		}
		int nowLen = getTextViewer().getReadingLength();
		// 後ろ向きの検索の場合、読み込みサイズを多くする。(検索結果を見やすくするため)
		getTextViewer().setReadingLength(
				nowLen + TextViewer.DEFAULT_READING_LENGTH * 5);
		getTextViewer().view();
		getTextViewer().setReadingLength(nowLen); // 読み込みサイズをもとに戻す
	}
}
