package jp.que.ti.yhj.utils;

import java.util.Properties;


/**
 * ファイルをコピーするためのクラスです
 * 
 * @author h.yan
 * @author $Author$ (last modified)
 * @version $Revision$
 */

public final class PropertiesUtils {
	/**
	 * プロパティーの値を取得します。<br>
	 * このメソッドは、システムプロパティー引数、引数 defauleProp の優先順で取得するプロパティーを決定する
	 * 
	 * @param key
	 *            プロパティー値を取得するためのキー
	 * @param prop
	 *            取得元のプロパティー
	 * @return プロパティー値。引数 key で指定したプロパティーが存在しない場合は null が返却されます。
	 */
	public static String getProperty(String key, Properties prop) {
		String prpval = System.getProperties().getProperty(key);
		if (prpval == null) {
			prpval = prop.getProperty(key);
		}
		return prpval;
	}

	/**
	 * ファイルパス用のプロパティーの値を取得します。<br>
	 * <ol>
	 * <li>このメソッドは、システムプロパティー引数、引数 defauleProp の優先順で取得するプロパティーを決定します。</li>
	 * <li>このメソッドは、システムに依存するデフォルトのファイル名の区切り文字を"/"に統一するため、プロパティー値中の"\"を"/"に変換して返却します。</li>
	 * </ol>
	 * 
	 * @param key
	 *            プロパティー値を取得するためのキー
	 * @param prop
	 *            取得元のプロパティー
	 * @return プロパティー値。引数 key で指定したプロパティーが存在しない場合は null が返却されます。
	 */
	public static String getFilePathProperty(String key, Properties prop) {
		return StringUtils.yen2Slash(getProperty(key, prop));
	}
}
