/*
 * created  2009/05/05 
 * Copyright 2008 yhj All rights reserved.
 */
package jp.que.ti.yhj.less.than.more.sw;

import java.awt.event.ActionListener;
import java.util.logging.Logger;

import jp.que.ti.yhj.less.than.more.LessThanMoreController;

/**
 * Swing GUI インターフェイス用の、{@link ActionListener}基本クラス
 * 
 * @author yhj
 * @author $Author$ (last modified)
 * @version $Revision$
 */
public abstract class LessThanMoreBaseActionListener implements ActionListener {
	/** このクラスが使用するログ出力用オブジェクトです */
	protected final Logger log = Logger.getLogger(getClass().getName());
	private LessThanMoreSwingFrameController controller;

	/**
	 * このクラスと協調する{@link LessThanMoreController} オブジェクトを取得します
	 * 
	 * @return このクラスと協調する{@link LessThanMoreController} オブジェクト
	 */
	public LessThanMoreSwingFrameController getController() {
		return controller;
	}

	/**
	 * このクラスと協調する{@link LessThanMoreController} オブジェクトを設定します
	 * 
	 * @param controller
	 *            このクラスと協調する{@link LessThanMoreController} オブジェクト
	 */
	public void setController(LessThanMoreSwingFrameController controller) {
		this.controller = controller;
	}
}
