/*
 * created  2008/08/11 
 * Copyright 2008 yhj All rights reserved.
 */
package jp.que.ti.yhj.less.than.more.command;

import java.util.logging.Level;
import java.util.logging.Logger;

import jp.que.ti.yhj.less.than.more.TextViewer;

/**
 * 文字列検索する命令を表現する基底クラス
 * 
 * @author yhj
 * @author $Author$ (last modified)
 * @version $Revision$
 */
public abstract class SearchBaseCMD extends Command {
	/** 情報ログレベルのレベルを格納するスタティックフィールです */
	public static Level infoLogLevel = Level.FINE;

	protected final Logger log = Logger.getLogger(getClass().getName());
	private String searchWord = "";

	/** コンストラクタ */
	protected SearchBaseCMD() {

	}

	/**
	 * コンストラクタ
	 * 
	 * @param textViewer
	 *            {@link TextViewer} オブジェクト
	 * @param searchWord
	 *            検索文字列
	 */
	protected SearchBaseCMD(TextViewer textViewer, String searchWord) {
		setTextViewer(textViewer);
		setSearchWord(searchWord);
	}

	/**
	 * 検索文字列を取得します
	 * 
	 * @return 検索文字列
	 */
	public final String getSearchWord() {
		return searchWord;
	}

	/**
	 * 検索文字列を設定します
	 * 
	 * @param searchWord
	 *            検索文字列
	 */
	public final void setSearchWord(String searchWord) {
		this.searchWord = searchWord;
	}
}
