/*
 * created  2008/09/21 
 * Copyright 2008 yhj All rights reserved.
 */
package jp.que.ti.yhj.less.than.more.sw;

import java.awt.Color;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.Map.Entry;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.Highlighter.HighlightPainter;

import jp.que.ti.yhj.less.than.more.swview.LessThanMoreDefaultFrame;
import jp.que.ti.yhj.less.than.more.util.LessThanMoreVersionUtils;
import jp.que.ti.yhj.utils.StringUtils;

/**
 * @author yhj
 * @author $Author$ (last modified)
 * @version $Revision$
 */
public class LessThanMoreSwingFrameIMPL extends LessThanMoreDefaultFrame {
	/** コマンドヘルプ文字列を生成するためのマップ。挿入順を保持させる */
	private static LinkedHashMap<String, String> KEY_HELP_MAP = new LinkedHashMap<String, String>();
	static {
		KEY_HELP_MAP.put("Ctl+o", "file open");
		KEY_HELP_MAP.put("Ctl+f", "next Page");
		KEY_HELP_MAP.put("Ctl+b", "previous Page");
	}

	/** コンストラクタ */
	public LessThanMoreSwingFrameIMPL() {
		super();
		getKeyHelpLbl().setText(helpLabelString());
	}

	private String helpLabelString() {
		Set<Entry<String, String>> est = KEY_HELP_MAP.entrySet();
		StringBuilder sb = new StringBuilder();
		boolean isFirst = true;
		for (Entry<String, String> entry : est) {
			if (isFirst) {
				isFirst = false;
			} else {
				sb.append(" | ");
			}
			sb.append(entry.getKey());
			sb.append(": ");
			sb.append(entry.getValue());
		}
		return sb.toString();
	}

	/** serialVersionUID */
	private static final long serialVersionUID = -6538342242419977266L;

	private JFileChooser openFileChooser;

	/**
	 * エンコーディングが変更され場合の {@link ActionListener} を追加するためのメソッド
	 * 
	 * @param listener
	 *            追加する {@link ActionListener}
	 */
	public void addActionListener4EncodingChanged(ActionListener listener) {
		getEncodingCombo().addActionListener(listener);
	}

	public void addActionListener4NextPage(ActionListener... listeners) {
		for (ActionListener listener : listeners) {
			getLessThanMoreDefaultPanel().getNextBtn().addActionListener(
					listener);
		}
		getLessThanMoreDefaultPanel().getNextBtn().requestFocus();
	}

	public void addActionListener4Position(ActionListener listener) {
		getPositionBtn().addActionListener(listener);
		getLessThanMoreDefaultPanel().getNowPositionjTextField()
				.addActionListener(listener);
	}

	public void addActionListener4PreviousPage(ActionListener... listeners) {
		for (ActionListener listener : listeners) {
			getLessThanMoreDefaultPanel().getPreviousBtn().addActionListener(
					listener);
		}
		getLessThanMoreDefaultPanel().getPreviousBtn().requestFocus();
	}

	public void addActionListener4Search(ActionListener listener) {
		getSearchBtn().addActionListener(listener);
		getLessThanMoreDefaultPanel().getSearchTextField().addActionListener(
				listener);
	}

	public void addText(String string) {
		final Document doc = getMainTextArea().getDocument();
		try {
			doc.insertString(doc.getLength(), string, null);
		} catch (BadLocationException e) {
			throw new RuntimeException(e.getCause().getMessage(), e);
		}
		setHighlight(getSearchWord()); // 検索後をハイライト表示
		textAreaCaretPosition(doc.getLength());
	}

	/**
	 * バージョン番号を取得します
	 * 
	 * @return バージョン番号
	 */
	@Override
	protected String getVersionNoString() {
		return LessThanMoreVersionUtils.version();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * jp.que.ti.yhj.less.than.more.sw.LessThanMoreSwingFrameIF#getEncodingCombo
	 * ()
	 */
	private JComboBox getEncodingCombo() {
		return getLessThanMoreDefaultPanel().getEncodingCombo();
	}

	public String getEncodingString() {
		final String encoding = "" + getEncodingCombo().getSelectedItem();
		return encoding;
	}

	private JTextArea getMainTextArea() {
		final JTextArea rtn = getLessThanMoreDefaultPanel().getMainTextArea();
		return rtn;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @seejp.que.ti.yhj.less.than.more.sw.LessThanMoreSwingFrameIF#
	 * getNowPositionjTextField()
	 */
	private JTextField getNowPositionjTextField() {
		final JTextField rtn = getLessThanMoreDefaultPanel()
				.getNowPositionjTextField();
		return rtn;
	}

	/**
	 * このフレームの現在位置入力欄に入力された文字列を返却します。
	 * 
	 * @return 現在位置入力欄に入力された文字列
	 */
	public String getNowPositionText() {
		final String rtn = getNowPositionjTextField().getText();
		return rtn;
	}

	private final JFileChooser getOpenFileChooser() {
		if (openFileChooser == null) {
			openFileChooser = new JFileChooser();
		}
		return openFileChooser;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * jp.que.ti.yhj.less.than.more.sw.LessThanMoreSwingFrameIF#getPositionBtn()
	 */
	private JButton getPositionBtn() {
		final JButton rtn = getLessThanMoreDefaultPanel().getPositionBtn();
		return rtn;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @seejp.que.ti.yhj.less.than.more.sw.LessThanMoreSwingFrameIF#
	 * getSearchBackwardCheckBox()
	 */
	private JCheckBox getSearchBackwardCheckBox() {
		final JCheckBox rtn = getLessThanMoreDefaultPanel()
				.getSearchBackwardCheckBox();
		return rtn;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * jp.que.ti.yhj.less.than.more.sw.LessThanMoreSwingFrameIF#getSearchBtn()
	 */
	private JButton getSearchBtn() {
		final JButton rtn = getLessThanMoreDefaultPanel().getSearchBtn();
		return rtn;
	}

	public String getSearchWord() {
		final String searchWord = getLessThanMoreDefaultPanel()
				.getSearchTextField().getText();
		return searchWord;
	}

	public String getText() {
		final String nowSrting = getMainTextArea().getText();
		return nowSrting;
	}

	/**
	 * 読み込みサイズを指定する文字列を取得する
	 * 
	 * @return 読み込みサイズを指定する文字列
	 */
	public String getReadingSizeString() {
		final String rtn = ""
				+ getLessThanMoreDefaultPanel().getReadingSizeComboCombo()
						.getSelectedItem();
		return rtn;
	}

	/**
	 * 読み込みサイズを指定する文字列を設定する
	 * 
	 * @param lentghString
	 *            読み込みサイズを指定する文字列
	 */
	public void setReadingLengthString(String lentghString) {
		getLessThanMoreDefaultPanel().getReadingSizeComboCombo()
				.setSelectedItem("" + lentghString);
	}

	/**
	 * 検索方向が前方方向であるか否かを返却する。
	 * 
	 * @return true の場合、前方方向検索。false の場合、後方検索
	 */
	public boolean isSearchForward() {
		boolean rtn = !(getSearchBackwardCheckBox().isSelected());
		return rtn;
	}

	public File selectFile() {
		int returnVal = getOpenFileChooser().showOpenDialog(this);
		File fl = null;
		if (returnVal == JFileChooser.APPROVE_OPTION) {
			fl = getOpenFileChooser().getSelectedFile();
		}
		return fl;
	}

	public void setFileSize(long fileSize) {
		getLessThanMoreDefaultPanel().getFileSizeLabel().setText(fileSize + "");
	}

	/**
	 * 検索語が指定されている場合は、ハイライト表示します。
	 * 
	 * @param searchWord
	 */
	private void setHighlight(String searchWord) {
		JTextArea textArea = getMainTextArea();
		Highlighter hilite = textArea.getHighlighter();
		hilite.removeAllHighlights();
		if (StringUtils.isEmpty(searchWord)) {
			return;
		}

		final Pattern pattern = Pattern.compile(searchWord);
		final String str = textArea.getText();
		final Matcher mtch = pattern.matcher(str);

		HighlightPainter highlightPainter = new DefaultHighlighter.DefaultHighlightPainter(
				Color.YELLOW);

		while (mtch.find()) {
			final int st = mtch.start();
			final int ed = mtch.end();
			try {
				hilite.addHighlight(st, ed, highlightPainter);
			} catch (BadLocationException e) {
				throw new RuntimeException(e.getMessage(), e);
			}
		}
	}

	public void setNowPosition(long nowPosition) {
		getLessThanMoreDefaultPanel().getNowPositionjTextField().setText(
				nowPosition + "");
	}

	public void setSearchWord(String searchWord) {
		getLessThanMoreDefaultPanel().getSearchTextField().setText(searchWord);
	}

	public void setStatusMessage(String message) {
		final JTextArea ta = getLessThanMoreDefaultPanel().getStatusTxtArea();
		ta.setText(message);
		ta.setCaretPosition(0);

	}

	public void setText(String string) {
		getMainTextArea().setText(string);
		setHighlight(getSearchWord()); // 検索後をハイライト表示
	}

	/**
	 * メインのテキスト表示域のテキスト挿入キャレットの位置を設定します。
	 * 
	 * @param position
	 *            位置
	 */
	public void textAreaCaretPosition(int position) {
		getLessThanMoreDefaultPanel().getMainTextArea().setCaretPosition(
				position);
	}
}
