/*
 * created  2008/06/23 
 * Copyright 2008 yhj All rights reserved.
 */
package jp.que.ti.yhj.less.than.more;

import java.io.File;

import junit.framework.TestCase;

/**
 * {@link LessThanMoreCUIController} のテストクラス
 * 
 * @author yhj
 * @author $Author$ (last modified)
 * @version $Revision$
 */
public class LessThanMoreCUIControllerTest extends TestCase {

	/**
	 * {@link LessThanMoreCUIController#lineParser(String[])}のテスト
	 * 
	 * @throws CannotContinueException
	 */
	public void test_lineParser() throws CannotContinueException {
		LessThanMoreCUIController cntl = null;
		String fileName = null;

		//
		cntl = new LessThanMoreCUIController();
		fileName = "testdata/test-sjis.txt";
		cntl.lineParser(new String[] { fileName });
		assertEquals(new File(fileName).getAbsolutePath()//
				, cntl.getViewer().getFile().getAbsolutePath());

		//
		fileName = "testdata/test-sjis.txt";
		cntl.lineParser(new String[] { "-e", "UTF-8", fileName });
		assertEquals("UTF-8", cntl.getViewer().getEncoding());
		assertEquals(new File(fileName).getAbsolutePath()//
				, cntl.getViewer().getFile().getAbsolutePath());

		//
		fileName = "testdata/test-sjis.txt";
		cntl.lineParser(new String[] { "--encoding", "UTF-8", fileName });
		assertEquals("UTF-8", cntl.getViewer().getEncoding());
		assertEquals(new File(fileName).getAbsolutePath()//
				, cntl.getViewer().getFile().getAbsolutePath());

	}

	public void test_usageString() {
		LessThanMoreCUIController cntl = null;
		cntl = new LessThanMoreCUIController();
		String helpString = cntl
				.usageString(LessThanMoreCUIController.LINE_OPTIONS);
		System.out.println(helpString);

		assertTrue(helpString
				.contains("usage: lessThanMore [OPTION]... [INPUT FILE]"));
		assertTrue(helpString
				.contains(" -e,--encoding <charsetName>   input file encoding"));
		assertTrue(helpString
				.contains(" -h,--help                     print this message"));

	}

	public void test_viewLoopUsageString() {
		LessThanMoreCUIController cntl = null;
		cntl = new LessThanMoreCUIController();
		String helpString = cntl.viewLoopUsageString();
		System.out.println(helpString);

		assertNotNull(helpString);
		assertTrue(helpString
				.contains(" b                        view privious page"));
		assertTrue(helpString
				.contains(" EnterKey                 view next page"));
		assertTrue(helpString
				.contains(" f                        view next page"));
		assertTrue(helpString
				.contains(" h                        print this message"));
		assertTrue(helpString.contains(" - <byte>  "));
		assertTrue(helpString.contains(" + <byte>  "));
		assertTrue(helpString
				.contains("q                        quit this aplication"));
		assertTrue(helpString.contains(" ? <search ward>   search backward"));
		assertTrue(helpString.contains(" / <search ward>      search forward"));
	}
}
