/*
 * created  2008/07/07 
 * Copyright 2008 yhj All rights reserved.
 */
package jp.que.ti.yhj.less.than.more;

import java.io.File;

import jp.que.ti.yhj.less.than.more.command.IllegalPositionException;
import jp.que.ti.yhj.less.than.more.test.LessThanMoreBaseTestCase;

/**
 * @author yhj
 * @author $Author$ (last modified)
 * @version $Revision$
 */
public class LessThanMoreControllerTest extends LessThanMoreBaseTestCase {
	LessThanMoreController controller = null;

	/*
	 * (non-Javadoc)
	 * 
	 * @see junit.framework.TestCase#setUp()
	 */
	@Override
	protected void setUp() throws Exception {
		super.setUp();
		controller = new LessThanMoreController() {
		};
	}

	/** {@link LessThanMoreController#searchForward()}のテスト */
	public void test_searchForward_searchBackward() {
		String rtn = null;
		controller.getViewer().setFile(new File("testdata/test-utf-8.txt"));
		controller.getViewer().setEncoding(TextViewer.UTF_8);
		controller.getViewer().setReadingLength(10);
		controller.getViewCommand().execute();

		controller.setSearchWord("さしすせそ");
		rtn = controller.searchForward();
		assertEquals("さしすせそ\r\n", rtn);
		assertEquals(controller.getViewer().getLastViewCache(), rtn);

		controller.setSearchWord("ポンポコナの");
		rtn = controller.searchForward();
		assertEquals("ポンポコナの長久命（ちょうきゅうめい）の長助", rtn);
		assertEquals(controller.getViewer().getLastViewCache(), rtn);

		controller.setSearchWord("ポンポコナの");
		try {
			rtn = controller.searchForward();
			fail("ファイルの最後まで検索して見つからず、例外が発生するはず");
		} catch (IllegalPositionException e) {
			assertTrue("ファイルの最後まで検索して見つからず、例外が発生するはず", true);
		}
		assertEquals(controller.getViewer().getFile().length()//
				, controller.getViewer().getPosition());

		// ちょうきゅうめい
		controller.setSearchWord("ちょうきゅうめい");
		rtn = controller.searchBackward();
		assertEquals("ちょうきゅうめい）の長助", rtn);
		assertEquals(controller.getViewer().getLastViewCache(), rtn);

		// ここから後方検索のテスト
		controller.setSearchWord("ポンポコナの");
		rtn = controller.searchBackward();
		assertEquals("ポンポコナの長久命（ちょうきゅうめい）の長助", rtn);
		assertEquals(controller.getViewer().getLastViewCache(), rtn);

		controller.setSearchWord("ポンポコナの");
		rtn = controller.searchBackward();
		assertEquals("ポンポコナの長久命（ちょうきゅうめい）の長助\r\n", rtn);
		assertEquals(controller.getViewer().getLastViewCache(), rtn);

		controller.setSearchWord("ポンポコナの");
		try {
			rtn = controller.searchBackward();
			fail();
		} catch (IllegalPositionException ipe) {
			assertTrue(true);
		}
		assertEquals(controller.getViewer().getLastViewCache(), rtn);
	}

	/** {@link LessThanMoreController#viewNextPage()}のテスト */
	public void test_viewNextPage() {
		String rtn = null;
		controller.getViewer().setFile(new File("testdata/test4page.txt"));
		controller.getViewer().setReadingLength(10);
		controller.getViewCommand().execute();

		rtn = controller.getViewer().getLastViewCache();
		assertEquals("abcde\n", rtn);

		rtn = controller.viewNextPage();
		assertEquals("fghij\r", rtn);

		rtn = controller.viewNextPage();
		assertEquals("klmnopqrstuvwxyz\n", rtn);

		rtn = controller.viewNextPage();
		assertEquals("ABCDEFGHIJK\r\n", rtn);

		rtn = controller.viewNextPage();
		assertEquals("LMNOP", rtn);
	}

	/** {@link LessThanMoreController#viewNextPage()}のテスト */
	public void test_viewPreviousPage() {
		String rtn = null;
		controller.getViewer().setFile(new File("testdata/test4page.txt"));
		controller.getViewer().setReadingLength(10);
		controller.getViewer().setPosition(29);
		controller.getViewCommand().execute();

		rtn = controller.getViewer().getLastViewCache();
		assertEquals("ABCDEFGHIJK\r\n", rtn);

		rtn = controller.viewPreviousPage();
		assertEquals("klmnopqrstuvwxyz\n", rtn);

		rtn = controller.viewPreviousPage();
		assertEquals("fghij\r", rtn);

		rtn = controller.viewPreviousPage();
		assertEquals("abcde\n", rtn);

		try {
			rtn = controller.viewPreviousPage();
			fail("例外が発生するはず");
		} catch (IllegalPositionException e) {
			assertTrue("予定通り例外発生", true);
		}
	}

	/** {@link LessThanMoreController#viewLastPage()}のテスト */
	public void test_viewLastPage() {
		String rtn = null;
		controller.getViewer().setFile(new File("testdata/test4page.txt"));

		controller.getViewer().setReadingLength(20);
		rtn = controller.viewLastPage();
		assertEquals("ABCDEFGHIJK\r\nLMNOP", rtn);

		controller.getViewer().setReadingLength(15);
		rtn = controller.viewLastPage();
		assertEquals("LMNOP", rtn);

		controller.getViewer().setReadingLength(3);
		rtn = controller.viewLastPage();
		assertEquals("LMNOP", rtn);

		controller.getViewer().setReadingLength(1000);
		rtn = controller.viewLastPage();
		assertEquals("abcde\nfghij\rklmnopqrstuvwxyz\nABCDEFGHIJK\r\nLMNOP",
				rtn);

		controller.getViewer().setFile(new File("testdata/test-utf-8.txt"));

		controller.getViewer().setEncoding(TextViewer.UTF_8);
		controller.getViewer().setReadingLength(3);
		rtn = controller.viewLastPage();
		assertEquals(
				"1234567890-^\\!\"#$%&'()=～|@｢;:｣､｡･\\`{+*}<>?_１２３４５６７８９０－＾￥！”＃＄％＆’（）＝～｜@｢；：」、。・￥‘｛＋＊｝＜＞？＿abcdefghijklmnopqrstuvwxwzABCDEFGHIJKLMNOPQRSTUVWXYZ寿限無（じゅげむ）寿限無、五劫（ごこう）のすりきれ、海砂利水魚（かいじゃりすいぎょ）の水行末（すいぎょうまつ）、雲来末（うんらいまつ）、風来末（ふうらいまつ）、食う寝るところに住むところ、やぶらこ うじのぶらこうじ、パイポパイポ、パイポのシューリンガン、シューリンガンのグーリンダイ、グーリンダイのポンポコピーのポンポコナの長久命（ちょうきゅうめい）の長助",
				rtn);
	}
}
