/*
 * LessThanMorePanel.java
 *
 * Created on 2008/09/07, 15:58
 */
package jp.que.ti.yhj.less.than.more.swview;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

/**
 *
 * @author  kaka
 */
public class LessThanMoreDefaultPanel extends javax.swing.JPanel {

    /** Creates new form LessThanMorePanel */
    public LessThanMoreDefaultPanel() {
        initComponents();
        coustomInitComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        mainTextArea = new javax.swing.JTextArea();
        jScrollPane2 = new javax.swing.JScrollPane();
        statusTxtArea = new javax.swing.JTextArea();
        jSplitPane1 = new javax.swing.JSplitPane();
        jSplitPane2 = new javax.swing.JSplitPane();
        fontSettingPanel = new jp.que.ti.yhj.less.than.more.swview.FontSettingPanel();
        encodingPanel = new jp.que.ti.yhj.less.than.more.swview.EncodingPanel();
        jSplitPane3 = new javax.swing.JSplitPane();
        readingSizePanel = new jp.que.ti.yhj.less.than.more.swview.ReadingSizePanel();
        jLabel1 = new javax.swing.JLabel();
        controlPanel1 = new jp.que.ti.yhj.less.than.more.swview.ControlPanel();

        mainTextArea.setColumns(20);
        mainTextArea.setRows(5);
        mainTextArea.setMinimumSize(new java.awt.Dimension(10, 10));
        jScrollPane1.setViewportView(mainTextArea);

        jScrollPane2.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
        jScrollPane2.setMaximumSize(new java.awt.Dimension(32767, 10));
        jScrollPane2.setMinimumSize(new java.awt.Dimension(5, 5));

        statusTxtArea.setBackground(javax.swing.UIManager.getDefaults().getColor("CheckBox.background"));
        statusTxtArea.setColumns(20);
        statusTxtArea.setEditable(false);
        statusTxtArea.setFont(new java.awt.Font("Monospaced", 0, 9));
        statusTxtArea.setLineWrap(true);
        statusTxtArea.setRows(5);
        statusTxtArea.setWrapStyleWord(true);
        statusTxtArea.setMaximumSize(new java.awt.Dimension(2147483647, 10));
        statusTxtArea.setMinimumSize(new java.awt.Dimension(5, 5));
        jScrollPane2.setViewportView(statusTxtArea);

        jSplitPane1.setBorder(null);
        jSplitPane1.setResizeWeight(0.7);
        jSplitPane1.setMaximumSize(new java.awt.Dimension(2147483647, 20));
        jSplitPane1.setMinimumSize(new java.awt.Dimension(10, 20));
        jSplitPane1.setPreferredSize(new java.awt.Dimension(153, 20));

        jSplitPane2.setBorder(null);
        jSplitPane2.setResizeWeight(0.5);
        jSplitPane2.setLeftComponent(fontSettingPanel);
        jSplitPane2.setRightComponent(encodingPanel);

        jSplitPane1.setLeftComponent(jSplitPane2);

        jSplitPane3.setBorder(null);
        jSplitPane3.setResizeWeight(0.8);
        jSplitPane3.setLeftComponent(readingSizePanel);

        jLabel1.setFont(new java.awt.Font("Monospaced", 0, 12));
        jLabel1.setText("<");
        jLabel1.setMaximumSize(new java.awt.Dimension(240, 20));
        jLabel1.setMinimumSize(new java.awt.Dimension(10, 20));
        jLabel1.setPreferredSize(new java.awt.Dimension(10, 20));
        jSplitPane3.setRightComponent(jLabel1);

        jSplitPane1.setRightComponent(jSplitPane3);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(controlPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, 802, Short.MAX_VALUE)
            .addComponent(jScrollPane2, javax.swing.GroupLayout.DEFAULT_SIZE, 802, Short.MAX_VALUE)
            .addComponent(jSplitPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 802, Short.MAX_VALUE)
            .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 802, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(jSplitPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 199, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(controlPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane2, javax.swing.GroupLayout.PREFERRED_SIZE, 33, javax.swing.GroupLayout.PREFERRED_SIZE))
        );
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private jp.que.ti.yhj.less.than.more.swview.ControlPanel controlPanel1;
    private jp.que.ti.yhj.less.than.more.swview.EncodingPanel encodingPanel;
    private jp.que.ti.yhj.less.than.more.swview.FontSettingPanel fontSettingPanel;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JSplitPane jSplitPane1;
    private javax.swing.JSplitPane jSplitPane2;
    private javax.swing.JSplitPane jSplitPane3;
    private javax.swing.JTextArea mainTextArea;
    private jp.que.ti.yhj.less.than.more.swview.ReadingSizePanel readingSizePanel;
    private javax.swing.JTextArea statusTxtArea;
    // End of variables declaration//GEN-END:variables

    //
    // このコンポーネントの初期化用フィールド(独自拡張)
    /** フォントサイズコンボボックスのユーザ入力前のインデックス値 */
    private int fontSizeComboLastSelectedIndex = 0;
    /** フォントサイズコンボボックスのユーザ入力前の値 */
    private int fontSizeComboLastSelectedValue = 12;

    /** このコンポーネントの初期化(独自拡張) */
    private void coustomInitComponents() {
        fontSizeComboLastSelectedIndex = fontSettingPanel.getFontSizeCombo().getSelectedIndex();
        fontSettingPanel.getFontSizeCombo().addActionListener(//
                new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                final String numStr = fontSettingPanel.getFontSizeCombo().getSelectedItem() + "";
                float size = 0;
                try {
                    size = Integer.parseInt(numStr);
                    Font newFont = getMainTextArea().getFont().deriveFont(size);
                    getMainTextArea().setFont(newFont);
                    fontSizeComboLastSelectedIndex = fontSettingPanel.getFontSizeCombo().getSelectedIndex();
                    fontSizeComboLastSelectedValue = (int) size;
                } catch (NumberFormatException ne) {
                    if (fontSizeComboLastSelectedIndex < 0) {
                        fontSettingPanel.getFontSizeCombo().setSelectedItem(fontSizeComboLastSelectedValue + "");
                    } else {
                        fontSettingPanel.getFontSizeCombo().setSelectedIndex(fontSizeComboLastSelectedIndex);
                    }
                }
            }
        });

        fontSettingPanel.getFontComboBox().addActionListener(//
                new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                final String numStr = fontSettingPanel.getFontSizeCombo().getSelectedItem() + "";
                int size = 0;
                try {
                    size = Integer.parseInt(numStr);
                } catch (NumberFormatException ne) {
                }
                Font newFont = new Font(fontSettingPanel.getFontComboBox().getSelectedItem() + "", Font.PLAIN, size);
                getMainTextArea().setFont(newFont);
            }
        });



    }

    public JTextField getSearchTextField() {
        return controlPanel1.getSearchTextField();
    }

    public JButton getSearchBtn() {
        return controlPanel1.getSearchBtn();
    }

    public JCheckBox getSearchBackwardCheckBox() {
        return controlPanel1.getSearchBackwardCheckBox();
    }

    public JButton getPreviousBtn() {
        return controlPanel1.getPreviousBtn();
    }

    public JButton getPositionBtn() {
        return controlPanel1.getPositionBtn();
    }

    public JTextField getNowPositionjTextField() {
        return controlPanel1.getNowPositionjTextField();
    }

    public JButton getNextBtn() {
        return controlPanel1.getNextBtn();
    }

    public JLabel getFileSizeLabel() {
        return controlPanel1.getFileSizeLabel();
    }

    /**
     * ステータス表示用の {@link JTextArea} の getter
     * @return ステータス表示用の {@link JTextArea}
     */
    public JTextArea getStatusTxtArea() {
        return statusTxtArea;
    }

    /**
     * テキスト表示用の {@link JTextArea} の getter
     * @return テキスト表示用の {@link JTextArea}
     */
    public JTextArea getMainTextArea() {
        return mainTextArea;
    }

    /**
     * エンコーディングを指定するためのコンボボックスの gettere
     * @return エンコーディングを指定するためのコンボボックス
     */
    public JComboBox getEncodingCombo() {
        return this.encodingPanel.getEncodingCombo();
    }

    /**
     * 一度に読み込むbyte数を指定するためのコンボボックスの gettere
     * @return 一度に読み込むbyte数を指定するためのコンボボックス
     */
    public JComboBox getReadingSizeComboCombo() {
        return this.readingSizePanel.getReadingSizeComboCombo();
    }
}
