/*
 * created  2008/09/21
 * Copyright 2008 yhj All rights reserved.
 */
package jp.que.ti.yhj.less.than.more.sw;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DnDConstants;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

import jp.que.ti.yhj.less.than.more.LessThanMoreController;
import jp.que.ti.yhj.less.than.more.swview.LessThanMoreDefaultPanel;
import jp.que.ti.yhj.utils.ExceptionUtils;
import jp.que.ti.yhj.utils.StringUtils;

/**
 * lessThanMore デフォルトのSwing 製 GUIを制御するコントローラ
 *
 * @author hjy
 * @author $Author$ (last modified)
 * @version $Revision$
 */
public class LessThanMoreSwingFrameController extends LessThanMoreController {
	private Logger log = Logger.getLogger(getClass().getName());
	private LessThanMoreSwingFrameIMPL frame = new LessThanMoreSwingFrameIMPL();

	public static void main(String[] args) {
		LessThanMoreSwingFrameController controller = new LessThanMoreSwingFrameController();
		try {
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
			// UIManager.setLookAndFeel(
			// "com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
			// UIManager.setLookAndFeel(
			// "com.sun.java.swing.plaf.mac.MacLookAndFeel");

		} catch (ClassNotFoundException ex) {
			System.out.println("例外発生" + ex.getMessage() + ex);
		} catch (InstantiationException ex) {
			System.out.println("例外発生" + ex.getMessage() + ex);
		} catch (IllegalAccessException ex) {
			System.out.println("例外発生" + ex.getMessage() + ex);
		} catch (UnsupportedLookAndFeelException ex) {
			System.out.println("例外発生" + ex.getMessage() + ex);
		} catch (RuntimeException ex) {
			System.out.println("例外発生" + ex.getMessage() + ex);
		}
		JFrame fm = (JFrame) (controller.getFrame());
		SwingUtilities.updateComponentTreeUI(fm);
		fm.add(new LessThanMoreDefaultPanel());
		// fm.setSize(640, 240);
		fm.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		fm.setVisible(true);
	}

	public LessThanMoreSwingFrameController() {
		getFrame().setTitle(APLICATION_NAME);
		getFrame()
				.setIconImage(new ImageIcon("lettthanmoreICO.png").getImage());
		iniEventHandler();
	}

	protected MenuConfig createMenueConfig() {
		final MenuConfig config = new MenuConfig(this);
		return config;
	}

	protected void iniEventHandler() {
		// ***
		new DropTarget(getFrame().getLessThanMoreDefaultPanel()
				.getMainTextArea(), fileDropListener);
		getFrame().addActionListener4EncodingChanged(
				encodingChangeActionListener);
		getFrame().addActionListener4Search(searchActionListener);
		getFrame().addActionListener4Position(positionActionListener);
		final MenuConfig config = createMenueConfig();
		final List<JMenu> menus = config.getTopMenus();
		for (JMenu menu : menus) {
			getFrame().getJMenuBar().add(menu);
		}

		Map<String, JMenuItem> items = config.getMenuItems();
		getFrame().addActionListener4NextPage(
				items.get(MenuConfig.NEXT_PAGE_KEY).getActionListeners());
		getFrame().addActionListener4PreviousPage(
				items.get(MenuConfig.PREVIOUS_PAGE_KEY).getActionListeners());
	}

	public void openFile(File fl) {
		try {
			getViewer().setFile(fl);
			getViewer().setPosition(0);
			getViewer().view();
			clearAndUpdate();
			textAreaCaretPositionToTop();
			getFrame().setTitle(
					APLICATION_NAME + " - " + fl.getName() + " "
							+ fl.getParentFile().getAbsolutePath());
		} catch (RuntimeException e) {
			log.log(Level.INFO, e.getMessage(), e);
			setStatusMessage(e);
		}
	}

	private DropTargetListener fileDropListener = new DropTargetAdapter() {
		@SuppressWarnings("unchecked")
		@Override
		public void drop(DropTargetDropEvent dtde) {
			try {

				Transferable transfer = dtde.getTransferable();
				if (transfer
						.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
					dtde.acceptDrop(DnDConstants.ACTION_COPY_OR_MOVE);
					List<File> fileList = (List<File>) (transfer
							.getTransferData(DataFlavor.javaFileListFlavor));
					if (fileList == null) {// nullならなにもしない
						return;
					}
					if (fileList.size() == 1) {
						final File fl = fileList.get(0);
						openFile(fl);
					} else {// ドロップは1ファイルのみ
						return;
					}
				}
			} catch (RuntimeException e) {
				log.log(Level.INFO, e.getMessage(), e);
				setStatusMessage(e);
			} catch (UnsupportedFlavorException e) {
				log.log(Level.INFO, e.getMessage(), e);
				setStatusMessage(e);
			} catch (IOException e) {
				log.log(Level.INFO, e.getMessage(), e);
				setStatusMessage(e);
			}
		}

	};

	public int readingSize() {
		final String rs = getFrame().getReadingSizeString();
		final int maxLength = 1000000;

		int readingLength = 0;
		try {
			readingLength = Integer.parseInt(toHalfWidthNumber(rs));
			if (readingLength < 0) { // マイナスの場合、もとに戻す
				readingLength = getViewer().getReadingLength();
			} else if (readingLength > maxLength) {// 1Mより大きい値の場合
				readingLength = maxLength - 1;
			}
		} catch (RuntimeException e) {
			// 数字とみなせない文字の場合、もとに戻す
			readingLength = getViewer().getReadingLength();
		}
		return readingLength;
	}

	private ActionListener encodingChangeActionListener = new ActionListener() {
		@Override
		public void actionPerformed(ActionEvent arg0) {
			if (getViewer().getFile() == null) {
				return;
			}
			try {
				getViewer().setEncoding(getFrame().getEncodingString());
				getViewer().view();
				clearAndUpdate();
			} catch (RuntimeException e) {
				log.log(Level.INFO, e.getMessage(), e);
				setStatusMessage(e);
			}
		}
	};

	private ActionListener searchActionListener = new ActionListener() {
		@Override
		public void actionPerformed(ActionEvent arg0) {
			if (getViewer().getFile() == null) {
				return;
			}
			try {
				final String searchWord = getFrame().getSearchWord();
				if (StringUtils.isEmpty(searchWord)) {
					return;
				} else {
					setSearchWord(searchWord);

					if (getFrame().isSearchForward()) {// 前方検索
						searchForward();
					} else {// 後方検索
						searchBackward();
					}
					clearAndUpdate();
					textAreaCaretPositionToTop();
				}
			} catch (RuntimeException e) {
				log.log(Level.INFO, e.getMessage(), e);
				setStatusMessage(e);
			}
		}
	};
	private static final char[] FULL_WIDTH_NUMBERS = { '０', '１', '２', '３', '４',
			'５', '６', '７', '８', '９' };

	private static String toHalfWidthNumber(String num) {
		char[] nums = num.toCharArray();
		boolean isChanged = false;
		for (int idx = 0; idx < nums.length; idx++) {
			final int result = Arrays.binarySearch(FULL_WIDTH_NUMBERS,
					nums[idx]);
			if (result >= 0) {
				nums[idx] = FULL_WIDTH_NUMBERS[result];
				isChanged = true;
			}
		}
		if (isChanged) {
			return new String(nums);
		} else {
			return num;
		}
	}

	private ActionListener positionActionListener = new ActionListener() {
		@Override
		public void actionPerformed(ActionEvent arg0) {
			if (getViewer().getFile() == null) {
				return;
			}
			final String positionString = getFrame().getNowPositionText();
			final String halfWidthPositionString = toHalfWidthNumber(positionString);

			long prePosition = getViewer().getPosition();
			long position = prePosition;
			try {
				position = Long.parseLong(halfWidthPositionString);
				if (position < 0 // マイナスの場合
						|| position > getViewer().getFile().length()// ファイルサイズより大きい値の場合
				) {
					// 前のポジションに戻す
					position = prePosition;
				}
			} catch (RuntimeException e) {
				// 数字とみなせない文字の場合、前のポジションに戻す
				position = prePosition;
			}
			getFrame().setNowPosition(position); // ビューの書き換え

			getViewer().setPosition(position);
			getViewer().view();
			clearAndUpdate();
			textAreaCaretPositionToTop();
		}
	};

	/**
	 * 例外や、チェックエラーが発生した場合の状況を意味するメッセージを格納します。
	 *
	 * @param e
	 *            状態変化の元となる例外
	 */
	protected void setStatusMessage(Exception e) {
		getFrame().setStatusMessage(e.getMessage() + "\n"//
				+ ExceptionUtils.stackTraceString(e));

	}

	/** 状態表示域をクリアする */
	public void clearStatusMessage() {
		getFrame().setStatusMessage("");
	}

	/** 現在読み込み済みのテキストキャッシュをテキスト表示域に上書きｓ表示し、読み込み位置を最新状態に更新します */
	public void clearAndUpdate() {
		final String str = getViewer().getLastViewCache();
		getFrame().setText(str);
		updatePosition();
	}

	/** テキストエリアのカーソル位置を先頭にする */
	public void textAreaCaretPositionToTop() {
		getFrame().textAreaCaretPosition(0);
	}

	/** 現在読み込み済みのテキストキャッシュをテキスト表示域に追加表示し、読み込み位置を最新状態に更新します */
	public void update() {
		final String str = getViewer().getLastViewCache();
		getFrame().addText(str);
		updatePosition();
	}

	/** 現在位置と、ファイルサイズを設定する */
	private void updatePosition() {
		final File fl = getViewer().getFile();
		if (fl != null//
				&& fl.exists() //
				&& fl.isFile()//
		) {
			getFrame().setFileSize(fl.length());
		}
		getFrame().setNowPosition(getViewer().getPosition());
	}

	/**
	 * frame を取得します。
	 *
	 * @return frame
	 */
	protected final LessThanMoreSwingFrameIMPL getFrame() {
		return frame;
	}

}
