/*
 * created  2009/05/05 
 * Copyright 2008 yhj All rights reserved.
 */
package jp.que.ti.yhj.less.than.more.sw;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.logging.Level;

/**
 * ファイルオープンのためのアクションリスナー
 * 
 * @author toto
 * @author $Author$ (last modified)
 * @version $Revision$
 */
public class OpenFileActionListener extends LessThanMoreBaseActionListener {
	@Override
	public void actionPerformed(ActionEvent event) {
		try {
			final File fl = getController().getFrame().selectFile();
			if (fl == null) {
				return; // ユーザがファイル選択キャンセル
			} else {
				getController().openFile(fl);
			}
		} catch (RuntimeException e) {
			log.log(Level.INFO, e.getMessage(), e);
			getController().setStatusMessage(e);
		}
	}

}
