/*
 * created  2008/06/24 
 * Copyright 2008 yhj All rights reserved.
 */
package jp.que.ti.yhj.less.than.more.command;

/**
 * 現在のアドレス位置を移動する命令
 * 
 * @author yhj
 * @author $Author$ (last modified)
 * @version $Revision$
 */
public class PositionCMD extends Command {
	public PositionCMD() {
	}

	/**
	 * コンストラクタ
	 * 
	 * @param skipBytes
	 *            次回読み込みの際に位置を移動する byte 数。 マイナスの指定は位置を現在の位置より前に移動することを意味する
	 */
	public PositionCMD(long skipBytes) {
		setSkipBytes(skipBytes);
	}

	private long skipBytes = 0;

	/**
	 * 次回読み込みの際に位置を移動する byte 数を取得する
	 * 
	 * @return 次回読み込みの際に位置を移動する byte 数。 マイナスの指定は位置を現在の位置より前に移動することを意味する
	 */
	public final long getSkipBytes() {
		return skipBytes;
	}

	/**
	 * 次回読み込みの際に位置を移動する byte 数を設定する
	 * 
	 * @param skipBytes
	 *            次回読み込みの際に位置を移動する byte 数。 マイナスの指定は位置を現在の位置より前に移動することを意味する
	 */
	public final void setSkipBytes(long skipBytes) {
		this.skipBytes = skipBytes;
	}

	/**
	 * {{@link #getTextViewer()} の現在の位置を移動する
	 */
	@Override
	public void execute() {
		forward(getSkipBytes());
	}

	private void forward(long forwardByte) {
		long position = getTextViewer().getPosition() + forwardByte;
		if (position < 0) {
			position = 0;
		}
		if (getTextViewer().getFile() == null) {
			final String msg = "file is null";
			throw new RuntimeException(msg);
		}
		if (position >= getTextViewer().getFile().length()) {
			final String msg = "The position is too large for a file.  file="
					+ getTextViewer().getFile().getAbsolutePath();
			throw new IllegalPositionException(msg);
		}
		getTextViewer().setPosition(position);
	}
}
