/*
 * created  2008/06/16 
 * Copyright 2008 yhj All rights reserved.
 */
package jp.que.ti.yhj.less.than.more.command;

import jp.que.ti.yhj.less.than.more.TextViewer;

/**
 * {@link TextViewer}に対するコマンドを定義した命令クラス。コマンドパターン
 * 
 * @author hyj
 * @author $Author$ (last modified)
 * @version $Revision$
 */
public interface CommandInterface {
	/** このコマンドを実行します */
	public void execute();

	/**
	 * このオブジェクトが処理対象とする {@link TextViewer} を取得します。
	 * 
	 * @return textViewer このオブジェクトが処理対象とする {@link TextViewer}
	 */
	public TextViewer getTextViewer();

	/**
	 * このオブジェクトが処理対象とする {@link TextViewer} を設定します。
	 * 
	 * @param textViewer
	 *            このオブジェクトが処理対象とする {@link TextViewer}
	 * @return このメソッドを持つインスタンス自身を返却します
	 */
	public CommandInterface setTextViewer(TextViewer textViewer);
}
