package jp.que.ti.yhj.less.than.more.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;

import org.mozilla.universalchardet.UniversalDetector;

public class EncodingUtils {
	public static final String UTF_8 = "UTF-8";
	public static final String UTF_16LE = "UTF-16LE";
	public static final String UTF_16BE = "UTF-16BE";
	public static final String UTF_16 = "UTF-16";
	public static final String ISO_8859_1 = "ISO-8859-1";
	public static final String US_ASCII = "US-ASCII";
	public static final String SHIFT_JIS = "SJIS";
	public static final String EUC_JP = "EUC-JP";
	public static final String WINDOWS_31J = "Windows-31J";

	private EncodingUtils() {
	};

	/**
	 * 引数で渡されたテキスト文字列バイト配列のエンコードを調べる
	 *
	 * @param bytes
	 *            バイト配列
	 * @return 判定結果のエンコーディング
	 */
	public static String ditectEncodingString(byte[] bytes) {
		UniversalDetector detector = new UniversalDetector(null);
		detector.handleData(bytes, 0, bytes.length);
		detector.dataEnd();

		String encoding = detector.getDetectedCharset();
		if ("SHIFT_JIS".equalsIgnoreCase(encoding)
				|| SHIFT_JIS.equalsIgnoreCase(encoding)) {
			return WINDOWS_31J;
		}
		return encoding;
	}

	public static String ditectEncodingString(File file) {
		byte[] readBuffer = new byte[1024 * 16];
		FileInputStream fis;
		try {
			fis = new FileInputStream(file);
		} catch (FileNotFoundException e) {
			throw new RuntimeException(e);
		}
		int readSize = 0;
		try {
			readSize = fis.read(readBuffer);
		} catch (IOException e) {
			throw new RuntimeException(e);
		}

		if (readBuffer.length == readSize) {
			//
		} else if (readBuffer.length == 0) {
			return defaultEncoding();
		} else {
			byte[] tmpBuf = new byte[readSize];
			System.arraycopy(readBuffer, 0, tmpBuf, 0, readSize);
			readBuffer = tmpBuf;
		}
		return ditectEncodingString(readBuffer);
	}

	final public static String defaultEncoding() {
		return UTF_8;
	}
}
