package jp.que.ti.yhj.utils.file;


import java.io.File;
import java.util.Comparator;

/**
 * {@link File}の絶対パスで比較する Comparator
 * 
 * @author Hajime.Yanagawa
 */
public class AbsoluteFilePathComparator implements Comparator<File> {
	/**
	 * 絶対パスで比較した結果を返却します
	 * 
	 * @param file1
	 *            比較対象の{@link File}オブジェクト
	 * @param file2
	 *            比較対象の{@link File}オブジェクト
	 * 
	 * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
	 */
	public int compare(File file1, File file2) {
		final String path1 = file1.getAbsolutePath();
		final String path2 = file2.getAbsolutePath();
		return path1.compareTo(path2);
	}

}
