package jp.que.ti.yhj.utils.log;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.LogManager;

/**
 * ログに関するするユーティリティーライブラリ
 * 
 * @author h.yan
 * @author $Author$ (last modified)
 * @version $Revision$
 */
public class LogUtils {
	private LogUtils() {
	}

	/** デフォルトのログ設定処理化 */
	public final static void initLoggerConfig() {
		initLoggerConfig("logging.properties");
	}

	/**
	 * ログ設定処理化
	 * 
	 * @param propFileName
	 *            設定ファイルパス。ファイル検索パスはクラスローダーから参照できる必要がある
	 */
	public final static void initLoggerConfig(String propFileName) {
		final InputStream prpIs = ClassLoader.getSystemClassLoader()
				.getResourceAsStream(propFileName);
		if (prpIs == null) {
			return;
		}
		try {
			LogManager.getLogManager().readConfiguration(prpIs);
		} catch (SecurityException e) {
			System.out.println("Logger設定ファイル " + propFileName + " が読み込めませんでした");
			e.printStackTrace();
		} catch (IOException e) {
			System.out.println("Logger設定ファイル " + propFileName + " が読み込めませんでした");
			e.printStackTrace();
		}
	}
}
